/*************************************************************************
*
* mbed BlackOne
*   Photo Frame Sample Program for Eleki Jack
*                                                   by Techand
**************************************************************************
*/

#include "mbed.h"
Serial pc(USBTX, USBRX); // tx, rx
Serial lcd(p9, p10);     // lcd serial port


// Function prototypes **************************
void set_RTC ();
void calendar();


/***********************************
*
*  Photo Frame Main
*
************************************
*/
int main() {
    wait(1);
    lcd.printf("\x1b@14Z"); // 57600bps
    lcd.baud(57600);
    wait(1);
    lcd.printf("\x1b@0Z");  // Clear all data (character & graphics)
    lcd.printf("\x1b[>5h"); // Curser OFF
    lcd.printf("\x1b@30Z"); // Set buffer0 for display
    
    set_RTC();              // Set and Start RTC
    
    calendar();             // format and display calender
     
  // Display "Photo"
  for (;;)
  { 
    for (int i=1 ;i<=8;i++)
    {
        lcd.printf("\x1b@%d;0I",i); 
        wait_ms(2000);
    }
  }
}


/*****************************
*
* Set and Init. RTC
*
******************************
*/
void set_RTC () {
    time_t seconds = time(NULL);
    
    if ( (signed)seconds == -1 )
    {
      // setup time
      struct tm t;

      t.tm_sec = 00;    // seconds 0-59
      t.tm_min = 00;    // minuits 0-59
      t.tm_hour = 10;   // hour    0-23
      t.tm_mday = 3;    // day     1-31
      t.tm_mon = 2;     // month   0-11
      t.tm_year = 112;  // year from 1900
          
      seconds = mktime(&t);
      set_time(seconds);
    }
}



/*****************************
*
* format and Display Calender
*
******************************
*/
void calendar()
{
    int w_today;
    int today;
    int w;
    
    char buff[16];
    
    int md[12] = {31,29,31,30,31,30,31,31,30,31,30,31}; // size of month. Leap Year This Year!
    char sun[] = {0x93,0xFA,0x00};                      // sunday
    char sat[] = {0x20,0x93,0x79,0x00};                 // Saturday
    char week[] = {0x20,0x8C,0x8E,0x20,0x89,0xCE,0x20,0x90,0x85,0x20,0x96,0xD8,0x20,0x8B,0xE0,0x00};   
                   // Week Header  "sun mon tue wed thu fri sat"
                   
    time_t seconds = time(NULL);
    struct tm *t = localtime(&seconds);
    
    lcd.printf("\x1b[8;0H");
    lcd.printf("\x1b[1;32;m");
    strftime(buff,15, "%Y %B", localtime(&seconds));
    lcd.printf("%s",buff);

    lcd.printf("\x1b[9;0H");
    lcd.printf("\x1b[1;31;m");
    lcd.printf("%s",sun);
    lcd.printf("\x1b[1;32;m");
    lcd.printf("%s",week);
    lcd.printf("\x1b[1;34;m");
    lcd.printf("%s",sat);

    today = t->tm_mday;
    w_today = t->tm_wday;
    
    w=0;
    w_today = (w_today - ((today % 7)-1));
    
    for ( int i = 1; i <= md[t->tm_mon]; i++)
    {
        lcd.printf("\x1b[%d;%dH",((w_today+w)/7)+10,(3*((w_today+w)%7))+0);
        
        lcd.printf("\x1b[1;32;m");
        
        if ( (w_today+w)%7 == 0)
        {
            lcd.printf("\x1b[1;31;m");
        }
        if ( (w_today+w)%7 == 6)
        {
            lcd.printf("\x1b[1;34;m");
        } 
        
        if ( i == today)
        {
            lcd.printf("\x1b[7m");
        } else
        {
            lcd.printf("\x1b[27m");
        }
        
        lcd.printf("%2d",i);
        w++;
    }        
}