#include "mbed.h"
Serial pc(USBTX, USBRX); // tx, rx
Serial e_Disp2(p9, p10); // tx, rx

// Kanji Messages
char msg2[] = {0x8a,0xbf,0x8e,0x9a,0x83,0x74,0x83,0x48,0x83,0x93,0x83,0x67,0x93,0xe0,0x91,0xa0,0x54,0x46,0x54,0x83,0x4a,0x83,0x89,0x81,0x5b,0x4c,0x43,0x44,0x82,0xc6};
char msg3[] = {0x58,0x62,0x65,0x65,0x96,0xb3,0x90,0xfc,0x83,0x82,0x83,0x57,0x83,0x85,0x81,0x5b,0x83,0x8b,0x82,0xcc,0x83,0x5c,0x83,0x50,0x83,0x62,0x83,0x67,0x82,0xf0,0x91,0x95,0xf5};
char msg4[] = {0x6d,0x62,0x65,0x64,0x81,0x69,0x4c,0x43,0x50,0x31,0x37,0x36,0x38,0x81,0x6a,0x82,0xcc,0x8a,0x88,0x97,0x70,0x82,0xcc,0x95,0x9d,0x82,0xf0,0x8d,0x4c,0x82,0xb0,0x82,0xe9};
char msg5[] = {0x4c,0x43,0x50,0x58,0x70,0x72,0x65,0x73,0x73,0x6f,0x81,0x40,0x4c,0x43,0x50,0x31,0x37,0x36,0x39,0x82,0xe0,0x4f,0x21};


// Display Kanji Message 
void msg()
{
  e_Disp2.printf("\x1b@0Z"); // clear all
  e_Disp2.printf("\x1b@0;0;320;240;0;0;32767z"); // Fill White BG-Buff

  e_Disp2.printf("\x1b[1;30;m");  // Set Color of Char to BLACK  
  e_Disp2.printf("%s\n\r",msg2);
  e_Disp2.printf("\x1b[1;31;m");  // Set Color of Char to RED
  e_Disp2.printf("%s\n\r",msg3);
  e_Disp2.printf("\x1b[1;32;m");  // Set Color of Char to GREEN
  e_Disp2.printf("%s\n\r",msg4);
  e_Disp2.printf("\x1b[1;34;m");  // Set Color of Char to BLUE
  e_Disp2.printf("%s\n\r",msg5);  

}



int main() {
    e_Disp2.printf("\x1b[2J");  // Clear all charactors and set curser to Homeposition
    
    e_Disp2.printf("\x1b@30Z"); // Set Buffer_0 to BackGround buffer
    e_Disp2.printf("\x1b@80Z"); // BackLight ON 
  for (;;)
  {   
    for (int i=1 ;i<=9;i++)
    { // Display Image
        e_Disp2.printf("\x1b@%d;0I",i);
        wait_ms(2000);        
    }
    msg(); // Display KANJI msg
    wait_ms(5000);
    e_Disp2.printf("\x1b[2J");
  }
}