#include <stdio.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "USBHost.h"
#include "Utils.h"
#include "ps3.h"
#include "ADK.h"
#include "mbed.h"

//#define  ADKLOG 1
#define  ADKLOG 0
#if ADKLOG
#define  LOG(...)       printf(__VA_ARGS__)
#define  Log(...)       printf(__VA_ARGS__)
#define  log(...)       printf(__VA_ARGS__)

#else
#define  LOG(...)       do {} while(0)
#define  Log(...)       do {} while(0)
#define  log(...)       do {} while(0)

#endif


PwmOut red1(p26);
PwmOut gren1(p24);
PwmOut blue1(p25);

PwmOut red2(p22);
PwmOut gren2(p23);
PwmOut blue2(p21);

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

/*
InterruptIn  sw1(p21);
InterruptIn  sw2(p22);
InterruptIn  sw3(p23);

DigitalIn sw1(p21);
DigitalIn sw2(p22);
DigitalIn sw3(p23);
*/
DigitalIn sw1(p17);
DigitalIn sw2(p19);
DigitalIn sw3(p20);

u8 readbuff[3];
u8 writebuf[3];
//switch data backup
u8 sw1b,sw2b,sw3b;


void AdkUSB::setup() {
    sw1.mode(PullUp);
    sw2.mode(PullUp);
    sw3.mode(PullUp);
    sw1b=sw2b=sw3b=sw1;
}

void AdkUSB::loop() {
    log("enter loop\r\n");
    u8 buf[3];
    int ret=-1;
    //booting wait
    //wait(10);
    while (!this->_loopend) {
        bool w_flag=false;
        //wait_ms(4);

        buf[0]=0x01;
        //switch1
        if (sw1!=sw1b) {
            log("sw1=%d\r\n",sw1.read());
            buf[1]=0;
            buf[2]=!sw1;
            ret=this->write(buf,sizeof(buf));
            //wait_ms(4);
            sw1b=sw1;
            w_flag=true;
        }
        //switch2
        if (sw2!=sw2b) {
            log("sw2=%d\r\n",sw2.read());
            buf[1]=1;
            buf[2]=!sw2;
            ret=this->write(buf,sizeof(buf));
            //wait_ms(4);
            sw2b=sw2;
            w_flag=true;
        }
        //switch3
        if (sw3!=sw3b) {
            log("sw3=%d\r\n",sw3.read());
            buf[1]=2;
            buf[2]=!sw3;
            ret=this->write(buf,sizeof(buf));
            //wait_ms(4);
            sw3b=sw3;
            w_flag=true;
        }

        if (!w_flag) {
            buf[0]=buf[1]=buf[2]=0;
            ret=this->write(buf,sizeof(buf));
        }
    }

    //reset
//    led1=led2=led3=led4=0.0;
      red1=gren1=blue1=led4=0.0;
      red2=gren2=blue2=0.0;
    log("---------------------------------------------------------------loop end\r\n");
}
void AdkreadCallback(int device, int endpoint, int status, u8* buf, int len, void* userData) {

    log("AdkreadCallback(int device=%d, int endpoint=%x, int status=%d, u8* buf=%p, int len=%d, void* userData=%p)\r\n",
        device,endpoint,status,buf,len,userData);

    AdkUSB* t = (AdkUSB*)userData;
    if (status!=0) {
        log("loop end.\r\n");
        t->loopend();
        return;
    }


//    gren=((float)buf[2])/255.0;
    if (buf[0] == 0x2) {
        if (buf[1] == 0x0) {
            log("led1=%d\r\n",buf[2]);
//            led1=((float)buf[2])/255.0;
            gren2=((float)buf[2])/255.0;
//        } else if (buf[1]==0x3) {
          } else if (buf[1]==0x1) {
//            led2=((float)buf[2])/255.0;
            red2=((float)buf[2])/255.0;
//        } else if (buf[1]==0x6) {
          } else if (buf[1]==0x2) {
//            led3=((float)buf[2])/255.0;
            blue2=((float)buf[2])/255.0;
          } else if (buf[1]==0x3) {
            red1=((float)buf[2])/255.0;
          } else if (buf[1]==0x4) {
            blue1=((float)buf[2])/255.0;
          } else if (buf[1]==0x5) {
            gren1=((float)buf[2])/255.0;
        }
    } else if (buf[0] ==0x3) {
        if (buf[1] == 0x0) {
            led4=buf[2]? 1.0:0.0;
        }
    }

    USBBulkTransfer(device, endpoint , buf, len, AdkreadCallback, userData);
    wait_ms(4);

}

/*
void AdkwriteCallback(int device, int endpoint, int status, u8* buf, int len, void* userData) {

    log("AdkwriteCallback(int device=%d, int endpoint=%x, int status=%d, u8* buf=%p, int len=%d, void* userData=%p)\r\n",
        device,endpoint,status,buf,len,userData);

    AdkUSB* t = (AdkUSB*)userData;

}
*/


int getProtocol(int device);
void sendString(int device, int index, const char *str);

bool switchDevice(int device) {

    if (1==getProtocol(device)) {
        log("device supports protocol 1\r\n");

    } else {
        log("could not read device protocol version\r\n");
        return false;
    }


    sendString(device,ACCESSORY_STRING_MANUFACTURER,"Google, Inc.");
    sendString(device,ACCESSORY_STRING_MODEL,"DemoKit");
    sendString(device,ACCESSORY_STRING_DESCRIPTION,"DemoKit Arduino Board");
    sendString(device,ACCESSORY_STRING_VERSION,"1.0");
    sendString(device,ACCESSORY_STRING_URI,"http://www.android.com");
    sendString(device,ACCESSORY_STRING_SERIAL,"0000000012345678");
    USBControlTransfer(device,
                       HOST_TO_DEVICE |REQUEST_TYPE_VENDOR|RECIPIENT_DEVICE,
                       ACCESSORY_START,
                       0,//value
                       0, //index
                       0,
                       0,
                       0,
                       0 );

    wait_ms(400);

    return true;

}


int getProtocol(int device) {
    s16 data=-1;
    USBControlTransfer(device,
                       DEVICE_TO_HOST|REQUEST_TYPE_VENDOR|RECIPIENT_DEVICE,
                       ACCESSORY_GET_PROTOCOL,
                       0,//value
                       0, //index
                       (u8*)&data,
                       2,
                       0,
                       0 );
    //printf("return %d\r\n",data);
    return data;

}

void sendString(int device, int index, const char *str) {

    LOG("send_string start(%d,%d,%s)  %d \r\n",device,index,str,strlen(str)+1);
    u8 buffer[255];
    strcpy((char*)buffer,str);
    //thankyou curryman san
    USBControlTransfer(device,
                       HOST_TO_DEVICE|REQUEST_TYPE_VENDOR|RECIPIENT_DEVICE,
                       ACCESSORY_SEND_STRING,
                       0,//value
                       index,
                       buffer,
                       strlen(str)+1
                      );

    LOG("send_string end(%d,%d,%s)\r\n",device,index,str);

}

//int  USBBulkTransfer(int device, int ep, u8* data, int length, USBCallback callback, void* userData)
int AdkUSB::read(u8 *buff, int len) {
    int ret=USBBulkTransfer(_device,input_ep|0x80,buff,len,0,0);
    log("adkUSB read  ret=%d \r\n",ret);
    return ret;
}

void AdkwriteCallback(int device, int endpoint, int status, u8* buf, int len, void* userData);

int AdkUSB::write(u8 *buff, int len) {
    log("adkUSB write -------                                                     xxx \r\n");
    int ret=USBBulkTransfer(_device,output_ep,buff,len/*,AdkwriteCallback,this*/);
    log("ret=%d \r\n",ret);
    return ret;
}

void AdkreadCallback(int device, int endpoint, int status, u8* buf, int len, void* userData);

AdkUSB::AdkUSB(int device, int configuration, int interfaceNumber) {

    log("connecting Android \r\n");
    _device = device;
    _configuration = configuration;
    _interfaceNumber = interfaceNumber;
    //for loop()
    _loopend=false;
    printf("device = %d configuration = %d interfaceNumber = %d\r\n", device, configuration, interfaceNumber);
    int err;

    u8 buffer[255];
    err = GetDescriptor(_device,DESCRIPTOR_TYPE_CONFIGURATION,0,buffer,4);

    if (err < 0) {
        log("Failed to get descriptor\r\n");
        return;
    }


    int len = buffer[2] | (buffer[3] << 8);
    if (len > sizeof(buffer)) {
        log("config descriptor too large\n");
        /* might want to truncate here */
        return;
    }
    err = GetDescriptor(_device,DESCRIPTOR_TYPE_CONFIGURATION,0,buffer,len);
    u8* p = buffer;
    input_ep=0;
    output_ep=0;
    EndpointDescriptor *epDesc;
    while (p<(buffer+len)) {
        u8 descLen  = p[0];
        u8 descType = p[1];
        log("descLen=%d,descType=%d\r\n",descLen,descType);
        switch (descType) {
            case DESCRIPTOR_TYPE_CONFIGURATION:
                log("config desc\r\n");
                break;
            case DESCRIPTOR_TYPE_INTERFACE:
                log("interface desc\r\n");
                break;
            case DESCRIPTOR_TYPE_ENDPOINT:
                epDesc=(EndpointDescriptor*)p;
                if (!input_ep && (epDesc->bEndpointAddress& 0x80)) {
                    input_ep=epDesc->bEndpointAddress& 0x7f;
                    //PacketSize drop
                    log("input Endpoint address=%d,wMaxPacketSize=%d,bmAttributes=%d\r\n",input_ep,epDesc->wMaxPacketSize,epDesc->bmAttributes);

                } else if (!output_ep) {
                    output_ep=epDesc->bEndpointAddress& 0x7f;
                    //PacketSize drop
                    log("output Endpoint address=%d,wMaxPacketSize=%d,bmAttributes=%d\r\n",input_ep,epDesc->wMaxPacketSize,epDesc->bmAttributes);
                } else {
                    //other
                    log("non input,output Endpoint address=%d,wMaxPacketSize=%d,bmAttributes=%d\r\n",input_ep,epDesc->wMaxPacketSize,epDesc->bmAttributes);
                }
                break;
            default:
                log("unkown desc type(%d) \r\n",descType);
        }
        p+=descLen;
    }

    if (!(input_ep && output_ep)) {
        log("can't find accessory endpoints\r\n");
        return;
    }

    log("SetConfiguration\r\n");
    err = SetConfiguration(device,configuration);
    if (err < 0) {
        log("SetConfiguration error\r\n");
        return;
    }

    log("interrupt setup\r\n");
    //interrupt setup
    int ret=USBBulkTransfer(_device,input_ep|0x80,readbuff,sizeof(readbuff),AdkreadCallback,this);
    log("ret=%d \r\n",ret);
    log("ADK Standby\r\n");

    this->setup();
}

