#include "control.h"
#include "sensor.h"
#include "steps.h"
#include "mbed.h"

#define MAXPROC 15

process procs[MAXPROC] = {0};

int main()
{
    init();
    while (true)
    {
        schedule();
    }
}

void init()
{
    // initialize i2c sensors
    schedule_proc("INITSENSE", &init_sensors);
    // set initial processes
    procs[0].status = READY;
    procs[0].start = &get_sensor_data;
    return;
}

char* get_output(int pid)
{
    return procs[pid].output;
}

void schedule()
{
    for (int i=0; i<MAXPROC; i++)
    {
        process proc = procs[i];
        if(proc.status == READY)
        {
            int ret = proc.start(i);
            // if the process returns 0, it means don't run again
            if (ret == 0)
            {
                // set proc.status to ZOMBIE
                // ZOMBIE means process
                // is no longer active, but
                // it's output buffer is still
                // needed.
                proc.status = ZOMBIE;
            }
            return;
        }
     }
}

int schedule_proc(char *sid, int (*funcptr)(int))
{
    for (int i=0; i<MAXPROC; i++)
    {
        process proc = procs[i];
        if(proc.status == EMPTY)
        {
            proc.status = READY;
            proc.start = funcptr;
            strncpy(proc.sid, sid, MAX_SID_LEN-1);
            // null terminate proc.sid
            proc.sid[MAX_SID_LEN-1] = 0;
            return i;
         }
     }
     // if no open processes, return -1
     return -1;
}