#ifndef NKC_LCD_H
#define NKC_LCD_H

Serial lcd(PTD3,NC);

int NKC_BAUD[9]={0,300,1200,2400,9600,14400,19200,57600,115200};

int lcd_baud_decode(int baud)
{
    int target_baud;
    target_baud=0;
    if(baud >= 1 && baud <= 8)
    {
        target_baud=baud;
    }
    else
    {
        for(int i = 1; i <=8; i++)
        {
            if(baud ==  NKC_BAUD[i])
            {
                target_baud=i;           
            }
        }
    }
    if(target_baud >0)
    {
        return(target_baud);
    }
    else
    {
        return(-1);   
    }    
}

int lcd_baud(int baud)
{
    int target_baud;
    target_baud=lcd_baud_decode(baud);
    if(target_baud > 0)
    {
        lcd.baud(NKC_BAUD[target_baud]);
        return(NKC_BAUD[target_baud]);
    }
    else
    {
        return(-1);   
    }     
}

int lcd_default_baud(int baud)
{
    int target_baud;
    target_baud=lcd_baud_decode(baud);
    if(target_baud < 0)
    {
        return(-1);   
    }  
    for(int i=1; i<=8; i++)
    {
        lcd.baud(NKC_BAUD[i]);
        lcd.printf("\xFE\x61%1i",target_baud);

        //wait(2E-3);  
        wait_us(2000);     
    }
    lcd.baud(NKC_BAUD[target_baud]);   
    return(NKC_BAUD[target_baud]);       
}

void lcd_on()
{
    lcd.printf("\xFE\x41");
    //wait(2E-3); 
        wait_us(2000); 
}

void lcd_off()
{
    lcd.printf("\xFE\x42");
    //wait(2E-3); 
        wait_us(2000); 
}

void lcd_ddram_address(int address)
{
    lcd.printf("\xFE\x45%c",address);
    //wait(2E-3); 
        wait_us(2000); 
}

int lcd_cursor(int row, int column)
{
    int row_offsets[4]={0x00, 0x40, 0x13, 0x53};
    int address;
    if( row < 0 || row > 3 || column < 0 || column > 19) {return(-1);}
    address = row_offsets[row]+column;
    lcd.printf("\xFE\x45%c",address);
    //wait(2E-3); 
        wait_us(2000); 
    return(address);
}

void lcd_home()
{
    lcd.printf("\xFE\x46");
    //wait(2E-3); 
        wait_us(2000); 
}

void lcd_underline_on()
{
    lcd.printf("\xFE\x47");
    //wait(2E-3); 
        wait_us(2000); 
}

void lcd_underline_off()
{
    lcd.printf("\xFE\x48");
    //wait(2E-3); 
        wait_us(2000); 
}

int lcd_underline(int select)
{
    if(select)
    {
        lcd_underline_on();
        return(true);
    }
    else
    {
        lcd_underline_off();
        return(false);
    }      
}

void lcd_backspace()
{
    lcd.printf("\xFE\x4E");
    //wait(2E-3); 
        wait_us(2000); 
}

void lcd_clear()
{
    lcd.printf("\xFE\x51");
    //wait(2E-3);
        wait_us(2000); 
}

void lcd_blink_on()
{
    lcd.printf("\xFE\x4B");
    //wait(2E-3); 
        wait_us(2000); 
}

void lcd_blink_off()
{
    lcd.printf("\xFE\x4C");
    //wait(2E-3);
        wait_us(2000); 
}

int lcd_blink(int select)
{
    if(select)
    {
        lcd_blink_on();
        return(true);
    }
    else
    {
        lcd_blink_off();
        return(false);
    }      
}

void lcd_move_left()
{
    lcd.printf("\xFE\x49");
    //wait(2E-3); 
        wait_us(2000); 
}

void lcd_move_right()
{
    lcd.printf("\xFE\x4A");
    //wait(2E-3); 
        wait_us(2000); 
}

void lcd_shift_left()
{
    lcd.printf("\xFE\x55");
    //wait(2E-3);
        wait_us(2000); 
}

void lcd_shift_right()
{
    lcd.printf("\xFE\x56");
    //wait(2E-3);
        wait_us(2000);  
}

#endif //NKC_LCD_H