#include "mbed.h"
#include "rtos.h"

#include "stdio.h"
#include "stdint.h"
#include "ctype.h"
#include "math.h"
#include "errno.h"

/* These are header files created for EE 3420 that are generally useful but add a minimum of dependencies */
#include "Freedom_headers.h"
//The following are names for pins by position on the headers
/*
The USB connections are on this end of the board

                                    J2_19   OO  J2_20
                                    J2_17   OO  J2_18
                                    J2_15   OO  J2_16
                                    J2_13   OO  J2_14
J3_2    OO  J3_1                    J2_11   OO  J2_12
J3_4    OO  J3_3                    J2_9    OO  J2_10
J3_6    OO  J3_5                    J2_7    OO  J2_8
J3_8    OO  J3_7                    J2_5    OO  J2_6
J3_10   OO  J3_9                    J2_3    OO  J2_4
J3_12   OO  J3_11                   J2_1    OO  J2_2
J3_14   OO  J3_13                   
J3_16   OO  J3_15                   J1_15   OO  J1_16
                                    J1_13   OO  J1_14
J4_2    OO  J4_1                    J1_11   OO  J1_12
J4_4    OO  J4_3                    J1_9    OO  J1_10
J4_6    OO  J4_5                    J1_7    OO  J1_8
J4_8    OO  J4_7                    J1_5    OO  J1_6
J4_10   OO  J4_9                    J1_3    OO  J1_4
J4_12   OO  J4_11                   J1_1    OO  J1_2

*/

#include "ASCII.h"

#ifndef TRUE
#define TRUE (1==1)
#endif

#ifndef FALSE
#define FALSE (1==0)
#endif

#ifndef BIT
#define BIT(N) (1 << (N))
#endif

//Pushbuttons (active-low), digital input or interrupt input
//pins need pull-up resistors
//DigitalIn left_button(PTC12, PullUp);
//InterruptIn left_button(PTC12, PullUp);
//DigitalIn right_button(PTC3, PullUp);
//InterruptIn right_button(PTC3, PullUp);

//User LEDs
//DigitalOut red_led(PTE29);
//DigitalOut green_led(PTD5);

//Light sensor (phototransistor)
//AnalogIn light_sensor(PTE22);

//Temperature sensor(LM34)
//AnalogIn LM34(PTC2);

//Speakers
//PwmOut speaker1(PTE21);
//PwmOut Speaker2(PTE23);

// All of the follwoing define "pc" identically
Serial pc(USBTX, USBRX);    // MBED standard pin names
//Serial pc(PTA2, PTA1);    // KL46Z pin names
//Serial pc(J1_4, J1_2);    // Jumper position pin names
//Serial pc(D1,D0);         // Arduino-equivalent pin names
/* USBTX=PTA2, USBRX=PTA1 */
/* UART0_TX=PTA2, UART0_RX=PTA1, so actually UART0 */
/* UART0 on KL46Z routed through OpenSDA chip to USB */
/* now "pc" refers to this virtualized com port on host computer*/

/* available functions */
/*
pc.baud()
pc.format()
pc.readable()
pc.writeable()
pc.read()
pc.write()
pc.getc()
pc.putc()
pc.gets()
pc.puts()
pc.printf()
pc.scanf()
*/

#include "VT100.h"
//The VT100 functions send terminal control commands to the "pc" serial port
/*
void vt100_home()
void vt100_move_cursor(int row, int column)
void vt100_save_cursor()
void vt100_unsave_cursor()
void vt100_up()
void vt100_up_by(int count)
void vt100_down()
void vt100_down_by(int count)
void vt100_right()
void vt100_right_by(int count)
void vt100_left()
void vt100_left_by(int count)
void vt100_erase_right()
void vt100_erase_left()
void vt100_erase_line()
void vt100_erase_above()
void vt100_erase_below()
void vt100_erase_screen()
void vt100_set_attribute(int attrib)
void vt100_text_default()
void vt100_text_bright()
void vt100_text_dim()
void vt100_text_underscore()
void vt100_text_blink()
void vt100_text_reverse()
void vt100_text_hidden()
void vt100_set_foreground(vt100_colors color)
void vt100_set_background(vt100_colors color)
*/

//#include "SLCD.h"
//slcd is the 4-digit, 7-segment LCD on the KL46Z
//SLCD slcd;
/* available functions */
/*
slcd.printf("1234");    // standard printf function, only charaters in ASCII_TO_WF_CODIFICATION_TABLE will display
slcd.putc('A');         // prints a single character 
slcd.Write_Char('A');   // prints a single character
slcd.All_Segments(y);   // y=1 for ALL segments on, 0 for ALL segments off  
slcd.DPx(y);            // x=DP1 to DP3, y=1 for on 0 for off
slcd.Colon(y);          // y=1 for on, 0 for off
slcd.CharPosition=x;    // x=0 to 3, 0 is start position
slcd.Home();            // sets next charater to posistion 0 (start)
slcd.Contrast (x);      // set contrast x=0 - 15, 0 lightest, 15 darkest    
*/

//#include "tsi_sensor.h"
//Touch Sensitive Interface
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif
//TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
    
/* available functions */    
/* float TSIAnalogSlider.readPercentage() */

#include "keypad4x4.h"
BusOut keypad4x4_columns(PTE19, PTE18, PTE17, PTE16);
BusIn keypad4x4_rows(PTA14, PTA15, PTA16, PTA17);
InterruptIn keypad4x4_interrupt(PTC16);
available functions:
/*
int keypad4x4_set_type(int type)
int keypad4x4_query(char *key_value, int * key_row, int *key_column)
char keypad4x4_getc(void)
int keypad4x4_input(char *key_value, int * key_row, int *key_column)

*/

#include "NKC_LCD.h"
Serial lcd(PTD3,NC);
//Serial lcd(J1_6,NC);
//available functions:
/*
int lcd_baud_decode(int baud)
int lcd_baud(int baud);
int lcd_default_baud(int baud);
void lcd_on()
void lcd_off()
void lcd_ddram_address(int address)
int lcd_cursor(int row, int column)
void lcd_home()
void lcd_underline_on()
void lcd_underline_off()
int lcd_underline(int select)
void lcd_backspace()
void lcd_clear()
void lcd_blink_on()
void lcd_blink_off()
int lcd_blink(int select)
void lcd_move_left()
void lcd_move_right()
void lcd_shift_left()
void lcd_shift_right()
*/

//Stepper motor driver (ULN2803A)
//BusOut stepper(PTB0, PTB1, PTB2, PTB3);
//BusOut stepper(J4_2, J4_4, J4_6, J4_8);

//DC Quad Half-Hmotor driver (SN754410)
//DigitalOut motor_1(PTB20);
//DigitalOut motor_2(PTE30);
//DigitalOut motor_3(PTB18);
//DigitalOut motor_4(PTB19);
//PwmOut motor_enable_12(PTA6);
//PwmOut motor_enable_34(PTA7);
//DigitalOut motor_enable_12(PTA6);
//DigitalOut motor_enable_34(PTA7);

//Servo motors
//PwmOut servo1(PTA4);
//PwmOut servo2(PTA5);

//Inter-integrated circuit bus
//I2C i2c0(PTE25, PTE24);       //internal I2C bus for accelerometer and magnetometer
//I2C i2c1(PTE0, PTE1);         //external I2C bus (commonly real-time clock);
//I2C i2c1(D14, D15);         //external I2C bus (commonly real-time clock);

//alternative serial port 
Serial uart1(PTE0,PTE1);

//IMPORTANT NOTE: i2c1 and uart1 both use PTE0/PTE1 so cannot be used simultaneously.

//common SPI (MSI, MISO, SCK, SS, use_gpio_ssel_t)
//SPI spi1(PTD6, PTD7, PTD5);
//SPI spi1(PTD6, PTD7, PTD5, PTD4, use_gpio_ssel_t);
//SPI spi1(D11, D12, D13);
//SPI spi1(D11, D12, D13, D10, use_gpio_ssel_t);

char pc_string[50];
char uart1_string[50];
int pc_count=0;
int uart1_count=0;
int pc_ready=0;
int uart1_ready=0;

char tempc;

    int main(){
            pc.baud(115200);
            lcd_baud(115200);
            lcd_default_baud(115200);
      
while(true)
{
        if(keypad4x4¬_ispressed())
        {
                tempc=pc.getc();
                pc_string[pc_count++]=tempc;
                if(pc_count>=40 || tempc==CR || tempc==LF)
                {
                    pc_string[pc_count++]=LF;
                    pc_string[pc_count++]=NULL;
                    pc_ready=1;
                }
        }
        if(keypad4x4_getchar())
        {
                keypad4x4_getc();
        }
     

}