#ifndef SEVEN_SEGMENT_H
#define SEVEN_SEGMENT_H

#ifndef BIT
#define BIT(N) (1 << (N))
#endif

/* This file contains routines for controlling a single seven segment   */
/* display.                                                             */
/* The assumption is of a common cathode display where each anode is    */
/* individually controlled by an active-high signal from a port pin.    */
/* The further assumption is that the control will be through an        */
/* eight-bit BusOut structure where the segment control bits are        */
/* defined from most significant to least significant as:               */
/* DP, G, F, E, D, C, B, A                                              */
/*
      AAA
     F   B
     F   B
     F   B
      GGG
     E   C
     E   C
     E   C  DP
      DDD   DP
*/

/*
#define SEG_A BIT(0)
#define SEG_B BIT(1)
#define SEG_C BIT(2)
#define SEG_D BIT(3)
#define SEG_E BIT(4)
#define SEG_F BIT(5)
#define SEG_G BIT(6)
#define SEG_DP BIT(7)

int seven_segment_pattern [16]= { 
(SEG_A+SEG_B+SEG_C+SEG_D+SEG_E+SEG_F),
(SEG_B+SEG_C),
(SEG_A+SEG_B+SEG_D+SEG_E+SEG_G),
(SEG_A+SEG_B+SEG_C+SEG_D+SEG_G),
(SEG_B+SEG_C+SEG_F+SEG_G),
(SEG_A+SEG_C+SEG_D+SEG_F+SEG_G),
(SEG_A+SEG_C+SEG_D+SEG_E+SEG_F+SEG_G),
(SEG_A+SEG_B+SEG_C),
(SEG_A+SEG_B+SEG_C+SEG_D+SEG_E+SEG_F+SEG_G),
(SEG_A+SEG_B+SEG_C+SEG_D+SEG_F+SEG_G),
(SEG_A+SEG_B+SEG_C+SEG_E+SEG_F+SEG_G),
(SEG_C+SEG_D+SEG_E+SEG_F+SEG_G),
(SEG_ASEG_D+SEG_E+SEG_F),
(SEG_B+SEG_C+SEG_D+SEG_E+SEG_G),
(SEG_A+SEG_D+SEG_E+SEG_F+SEG_G),
(SEG_A+SEG_E+SEG_F+SEG_G)
};
*/

int seven_segment_pattern [16]= {0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x6F,0x77,0x7C,0x39,0x5E,0x79,0x71};
/*                               0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   A,   b,   C,   d,   E,   F  */    

//BusOut seven_segment(SEVEN_SEGMENT_A,SEVEN_SEGMENT_B,SEVEN_SEGMENT_C,SEVEN_SEGMENT_D,SEVEN_SEGMENT_E,SEVEN_SEGMENT_F,SEVEN_SEGMENT_G,SEVEN_SEGMENT_DP);
BusOut seven_segment(NC, NC, NC, NC, NC, NC, NC, NC);

int seven_segment_find_pattern(char ss_out)
{

    if((ss_out >= 0) && (ss_out <=15))
    {
        return(seven_segment_pattern[ss_out]);
    }
    else if((ss_out >= '0') && (ss_out <='9'))
    {
        return(seven_segment_pattern[ss_out-'0']);
    }
    else if((ss_out >= 'A') && (ss_out <='F'))
    {
        return(seven_segment_pattern[ss_out-'A'+10]);
    }
    else if((ss_out >= 'a') && (ss_out <='f'))
    {
        return(seven_segment_pattern[ss_out-'a'+10]);
    }
    else if(ss_out =='*')
    {
        return(seven_segment_pattern[0x0E]);
    }
    else if(ss_out =='#')
    {
        return(seven_segment_pattern[0x0F]);
    }
    else 
    {
       return(0);
    }
    
}   /* end of seven_segment_output() */
    
int seven_segment_output(char ss_out)
{
    int pattern;
    pattern=seven_segment_find_pattern(ss_out);
    seven_segment=pattern;
    return(pattern);
      
}   /* end of seven_segment_output() */




#endif /* #ifndef SEVEN_SEGMENT_H */