#ifndef VT100_H
#define VT100_H

#include "ASCII.h"

void vt100_home()
{
    pc.printf("\x1b[H");
}

void vt100_move_cursor(int row, int column)
{
    pc.printf("\x1b[%i;%iH",row,column);
}

void vt100_save_cursor()
{
    pc.printf("\x1b[s");
}

void vt100_unsave_cursor()
{
    pc.printf("\x1b[u");
}

void vt100_up()
{
    pc.printf("\x1b[A");
}

void vt100_up_by(int count)
{
    pc.printf("\x1b[%iA",count);
}

void vt100_down()
{
    pc.printf("\x1b[B");
}

void vt100_down_by(int count)
{
    pc.printf("\x1b[%iB",count);
}

void vt100_right()
{
    pc.printf("\x1b[C");
}

void vt100_right_by(int count)
{
    pc.printf("\x1b[%iC",count);
}

void vt100_left()
{
    pc.printf("\x1b[D");
}

void vt100_left_by(int count)
{
    pc.printf("\x1b[%iD",count);
}

void vt100_erase_right()
{
    pc.printf("\x1b[K");
}

void vt100_erase_left()
{
    pc.printf("\x1b[1K");
}

void vt100_erase_line()
{
    pc.printf("\x1b[2K");
}

void vt100_erase_above()
{
    pc.printf("\x1b[J");
}

void vt100_erase_below()
{
    pc.printf("\x1b[1J");
}

void vt100_erase_screen()
{
    pc.printf("\x1b[2J");
}

void vt100_set_attribute(int attrib)
{
    pc.printf("\x1b[%xm",attrib);
}

enum vt100_colors
{
    black=0,
    red=1,
    green=2,
    yellow=3,
    blue=4,
    magenta=5,
    cyan=6,
    white=7
};

void vt100_text_default()
{
    vt100_set_attribute(0);
}

void vt100_text_bright()
{
    vt100_set_attribute(1);
}

void vt100_text_dim()
{
    vt100_set_attribute(2);
}

void vt100_text_underscore()
{
    vt100_set_attribute(4);
}

void vt100_text_blink()
{
    vt100_set_attribute(5);
}

void vt100_text_reverse()
{
    vt100_set_attribute(7);
}

void vt100_text_hidden()
{
    vt100_set_attribute(8);
}

void vt100_set_foreground(int color)
{
    if(color<0 || color > 7)
    {
        printf("\ncolor must be in the range 0-7\n");
        return;
    }
    vt100_set_attribute(0x30+color);
}

void vt100_set_background(int color)
{
    if(color<0 || color > 7)
    {
        printf("\ncolor must be in the range 0-7\n");
        return;
    }
    vt100_set_attribute(0x40+color);
}

#endif //VT100_H