/**
 ******************************************************************************
 * @file    main.cpp
 * @author  SRA
 * @version V1.0.0
 * @date    5-March-2019
 * @brief   Simple Example application for using the X_NUCLEO_IKS01A3
 *          MEMS Inertial & Environmental Sensor Nucleo expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2019 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/

/* Includes */
#include "mbed.h"
#include "rtos.h"
#include "XNucleoIKS01A3.h"

#define PI 3.14159
int32_t minx,miny,minz,maxx,maxy,maxz;


/* Instantiate the expansion board */
static XNucleoIKS01A3 *mems_expansion_board = XNucleoIKS01A3::instance(D14, D15);//, D4, D5, A3, D6, A4);

/* Retrieve the composing elements of the expansion board */
static LIS2MDLSensor *magnetometer = mems_expansion_board->magnetometer;


void calibra()
{
    int32_t axes[3];

    magnetometer->get_m_axes(axes);
    
    //setto tutti i valori alla prima lettura
    minx=axes[0];
    miny=axes[1];
    minz=axes[2];
    maxx=minx;
    maxy=miny;
    maxz=minz;
    //imposto un timer per leggere per 10 secondi
    Timer t;
    t.start();
    while(t.read()<10){
       
        magnetometer->get_m_axes(axes);
    
        if (minx>axes[0])minx=axes[0];      
        if (miny>axes[1])miny=axes[1];
        if (minz>axes[2])minz=axes[2];
        if (maxx<axes[0])maxx=axes[0];      
        if (maxy<axes[1])maxy=axes[1];
        if (maxz<axes[2])maxz=axes[2];
    }
    t.stop();
    printf("LIS2MDL [mag/mgauss]:  minx %6d, maxx %6d, miny %6d maxy %6d\r\n", minx,maxx,miny,maxy);
    
}
void normalizza(int32_t axes[]){
    int32_t max,min;
    
    if (minx>axes[0])max=minx;
    else max=axes[0];
    if (max<maxx)min=max;
    else min=maxx;
    axes[0]=(min-minx)*200/(maxx-minx)-100;
    
    if (miny>axes[1])max=miny;
    else max=axes[1];
    if (max<maxy)min=max;
    else min=maxy;
    axes[1]=(min-miny)*200/(maxy-miny)-100;
   
    }
    
/* Simple main function */
int main()
{
    uint8_t id;
    //float value1, value2;
    //char buffer1[32], buffer2[32];
    int32_t axes[3];
    int direzione=0;
    
    /* Enable all sensors */
    magnetometer->enable();
    magnetometer->read_id(&id);
    calibra();
  
  //  magnetometer->get_m_axes(axes);
   // printf("LIS2MDL [mag/mgauss]:  %6d, %6d, %6d\r\n", axes[0], axes[1], axes[2]);
        
    while (1) {
        
        magnetometer->get_m_axes(axes);
        normalizza(axes);
        direzione = atan2(axes[1], axes[0]) * 180.0 / PI;
        direzione+=180;
        printf("gradi=%d\r\n",direzione);
        ThisThread::sleep_for(500);
    }
    
    
}
