#include "mbed.h"
#include "Camera_LS_Y201.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include <stdio.h>

#define DEBMSG      printf
#define DEBUG       printf("Bug me")
#define NEWLINE()   printf("\r\n")

#define USE_SDCARD 0


#define FILENAME    "/sd/IMG_%04d.jpg"
SDFileSystem fs(p5, p6, p7, p8, "sd");

//#define FILENAME    "/local/IMG_%04d.jpg"
//LocalFileSystem fs("local");

Camera_LS_Y201 cam1(p13, p14);

AnalogIn sensor(p19);
DigitalOut led(LED1);
uLCD_4DGL uLCD(p28,p27,p11); // serial tx, serial rx, reset pin;
AnalogOut DACout(p18);
wave_player waver(&DACout);
Serial pc(USBTX, USBRX);
Serial device(p9,p10);

typedef struct work {
    FILE *fp;
} work_t;

work_t work;

void regularSub() {

}
void microInterrupt() {
    int strikes = 0;
    char rchar=0;
//wake up device - needs more work and a timeout
    device.putc('b');
    while (device.getc()!='o') {
        DEBMSG("First While loop.");
        NEWLINE();
        device.putc('b');
        wait(0.2);
    }
    while (strikes<=3) {
    DEBMSG("Second While loop.");
    NEWLINE();        
        device.putc('i'); //Start Recognition
        device.putc('B'); //Use Wordset 3 - the numbers 1..10
//Use built-in speaker independent numbers (0..10) and listen for a number
        while (device.readable()!=0) {DEBMSG("Third While loop.");
    NEWLINE();}
        if (device.getc()=='s') {
            device.putc(' ');
            rchar=device.getc();
            if (rchar=='G') {DEBMSG("Correct Command.");
            //strikes--;
    NEWLINE();
    uLCD.text_width(2); //4X size text
        uLCD.text_height(2);
        uLCD.cls();
    uLCD.color(GREEN);
    uLCD.printf("Correct Command");
    wait(5);
    uLCD.cls();
        wait(2);
        uLCD.color(RED);
        uLCD.text_width(3); //4X size text
        uLCD.text_height(3);
        uLCD.printf("Alarm is turn off"); //Default Green on black text
        strikes = 4;
    }
            else {
                strikes++;
                DEBMSG("Wrong Command.");
                uLCD.cls();
                uLCD.text_width(2); //4X size text
                uLCD.text_height(2);
                uLCD.color(RED);
                uLCD.printf("Wrong Command");
                wait(5);
                uLCD.cls();
    NEWLINE();
            while(strikes==4){    
            DEBMSG("buzzing While loop.");
    NEWLINE();
            FILE *wave_file;
            wave_file=fopen("/sd/buzzer2.wav","r");
            waver.play(wave_file);
            fclose(wave_file);
            } 
            }
             
        }
    }
}
/**
 * Callback function for readJpegFileContent.
 *
 * @param buf A pointer to a buffer.
 * @param siz A size of the buffer.
 */
void callback_func(int done, int total, uint8_t *buf, size_t siz) {
    fwrite(buf, siz, 1, work.fp);

    static int n = 0;
    int tmp = done * 100 / total;
    if (n != tmp) {
        n = tmp;
        DEBMSG("Writing...: %3d%%", n);
        NEWLINE();
    }
}

/**
 * Capture.
 *
 * @param cam A pointer to a camera object.
 * @param filename The file name.
 *
 * @return Return 0 if it succeed.
 */
int capture(Camera_LS_Y201 *cam, char *filename) {
    /*
     * Take a picture.
     */
    if (cam->takePicture() != 0) {
        return -1;
    }
    DEBMSG("Captured.");
    NEWLINE();

    /*
     * Open file.
     */
    work.fp = fopen(filename, "wb");
    if (work.fp == NULL) {
        return -2;
    }

    /*
     * Read the content.
     */
    DEBMSG("%s", filename);
    NEWLINE();
    if (cam->readJpegFileContent(callback_func) != 0) {
        fclose(work.fp);
        return -3;
    }
    fclose(work.fp);

    /*
     * Stop taking pictures.
     */
    cam->stopTakingPictures();

    return 0;
}

/**
 * Entry point.
 */
int main(void) {
        while(1){   
        DEBMSG("Checking again");
        NEWLINE();
        if(sensor > 0.3) {
        //pc.printf("The distance is %d\n",sensor);
        uLCD.cls();
        wait(2);
        uLCD.color(RED);
        uLCD.text_width(3); //4X size text
        uLCD.text_height(3);
        uLCD.printf("Alarm is turn off"); //Default Green on black text
        } else {
        uLCD.cls();
        uLCD.color(GREEN);
        uLCD.text_width(3); //4X size text
        uLCD.text_height(3);
        uLCD.printf("Alarm is turn on");
        uLCD.cls();
        uLCD.printf("A picture is taken now");
        wait(3);
        uLCD.cls();
        uLCD.printf("Alarm is turn on");
        DEBMSG("Camera module");
    NEWLINE();
    DEBMSG("Resetting...");
    NEWLINE();
    wait(1);

    if (cam1.reset() == 0) {
        DEBMSG("Reset OK.");
        NEWLINE();
    } else {
        DEBMSG("Reset fail.");
        NEWLINE();
        error("Reset fail.");
    }
    wait(1);

    int cnt = 0;
        char fname[64];
        snprintf(fname, sizeof(fname) - 1, FILENAME, cnt);
        int r = capture(&cam1, fname);
        if (r == 0) {
            DEBMSG("[%04d]:OK.", cnt);
            NEWLINE();
        } else {
            DEBMSG("[%04d]:NG. (code=%d)", cnt, r);
            NEWLINE();
            error("Failure.");
        }
        cnt++;
        
        microInterrupt();
        }
    }
    
}
