#include "mbed.h"
#include "mpr121.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Serial device(p13, p14);  // tx, rx
//SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
//AnalogOut DACout(p18);
//wave_player waver(&DACout);

//analog input for four motion sensors
AnalogIn s1(p19);
AnalogIn s2(p20);

uLCD_4DGL uLCD(p28, p27, p11); // create a global lcd object


// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);
// Setup the i2c bus on pins 9 and 10
I2C i2c(p9, p10);
// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

int count;
int passcode=0;
int miss=0;
int strikes=0;


// voice recognition interrupt
void microInterrupt() {
//    FILE *alarm;
//    FILE *tryagain;
//    FILE *notaccept;
//    alarm=fopen("/sd/wavfiles/BurglarAlarm.wav","r");
//    tryagain=fopen("/sd/wavfiles/tryagain.wav","r");
//    notaccept=fopen("/sd/wavfiles/notaccept.wav","r");

    strikes=0;
    char rchar=0;
    //wake up device - needs more work and a timeout
    device.putc('b');
    while (device.getc()!='o') {
        device.putc('b');
        led1 = 1;
        wait(0.2);
    }
    led2=1;
    while (strikes!=3) {
        device.putc('i'); //Start Recognition
        device.putc('B'); //Use Wordset 1 - words
        //Use built-in speaker independent words and listen for words
        while (device.readable()!=0) {}
        if (device.getc()=='s') {
            device.putc(' ');
            rchar=device.getc();
            if (rchar=='H') {
                led1=!led1;
                uLCD.cls();
                uLCD.locate(1,8);
                uLCD.printf("\nVOICE COMMAND CORRECT.\n");
                wait(1);
                uLCD.cls();
                uLCD.printf("Silent alarm has been turned off.");
            } else {
                strikes++;
                led3=!led3;
//                waver.play(notaccept);
//                fclose(notaccept);
//                waver.play(tryagain);
//                fclose(tryagain);
                if (strikes == 3) {
                    //SOUND OFF ALARM
                    led2=0;
                    led3=0;
                    uLCD.locate(1,8);
                    uLCD.printf("\nToo many invalid passcodes.\n INTRUDER ALERT!\n");
                    wait(1);
                    uLCD.cls();
                    uLCD.text_width(3); //4X size text
                    uLCD.text_height(3);
                    uLCD.locate(0,0);
                    uLCD.printf("Alerting Authorities!");
//                    waver.play(alarm);
//                    fclose(alarm);
                }
            }
        }
    }
}

// Disarm alarm interrupt routine
void disarmInterrupt() {
      //create wave file
//    FILE *alarm;
//    FILE *pw=fopen("/sd/wavfiles/notaccept.wav","r");
//    alarm=fopen("/sd/wavfiles/BurglarAlarm.wav","r");

    uLCD.cls();
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
      // LED demo mod
      i=0;
      // puts key number out to LEDs for demo
      for (i=0; i<12; i++) {
        if (value & (1<<i))
            break;
      }
      
    uLCD.text_width(3); //4X size text
    uLCD.text_height(3);
    uLCD.color(WHITE);
    uLCD.locate(2,1);

    if (i == 0) {
        uLCD.printf("%d", i);
        passcode++;
    } else if( i == 1) {
        uLCD.printf("%d", i);
        passcode++;
    } else if( i == 2) {
        uLCD.printf("%d", i);
        passcode++;
    } else if(i == 3) {
        uLCD.printf("%d", i);
        passcode++;
    } else if(i == 4) {
        uLCD.printf("%d", i);
        miss++;
        passcode++;
    } else if(i == 5) {
        uLCD.printf("%d", i);
        miss++;
        passcode++;
    } else if(i == 6) {
        uLCD.printf("%d", i);
        miss++;
       passcode++;
    } else if(i == 7) {
        uLCD.printf("%d", i);
        miss++;
       passcode++;
    } else if(i == 8) {
        uLCD.printf("%d", i);
        miss++;
        passcode++;
    } else if(i == 9) {
        uLCD.printf("%d", i);
        miss++;
        passcode++;
    } else if(i == 10) {
        uLCD.printf("%d", i);
        miss++;
        passcode++;
    } else if(i == 11) {
        uLCD.printf("%d", i);
        miss++;
        passcode++;
    }
   
    if (passcode==4) {
        if(miss==0) {
            led1=1;
    
            //CHECKPOINT
            uLCD.cls();
            uLCD.text_width(1); //4X size text
            uLCD.text_height(1);
            uLCD.color(GREEN);
            uLCD.locate(1,8);
            uLCD.printf("\nPASSCODE CORRECT.\n");
            wait(1);
            uLCD.cls();
            uLCD.locate(1,2);
            uLCD.printf("\nSay Voice Command:\n");
            microInterrupt();
            
        } else {
            led3=!led3;
//            uLCD.cls();
//            uLCD.text_width(1); //4X size text
//            uLCD.text_height(1);
//            uLCD.locate(1,8);
//            uLCD.printf("\nPasscode invalid. Try again\n");
            miss=0;
            passcode=0;
            strikes++;            
                        //ALARM GOES OFF
            if(strikes==3) {
                led1=!led1;
                led3=!led3;
                uLCD.text_width(1); //4X size text
                uLCD.text_height(1);
                uLCD.locate(1,8);
                uLCD.color(RED);
                uLCD.printf("\nToo many invalid passcodes.\n INTRUDER ALERT!\n");
//                wait(0.2);
//                waver.play(pw);
//                fclose(pw);
                wait(1);
                uLCD.cls();
                uLCD.text_width(3); //4X size text
                uLCD.text_height(3);
                uLCD.locate(0,0);
                uLCD.printf("Alerting Authorities!");
//                waver.play(alarm);
//                fclose(alarm);
            }
        }
    }
} 
    

int main() {
    uLCD.printf("This security system is currently on.");
    wait(3);
    uLCD.cls();
    uLCD.locate(1,2);
    uLCD.printf("\nEnter passcode:\n");

    interrupt.fall(&disarmInterrupt);
    interrupt.mode(PullUp);
//    FILE *alarm = fopen("/sd/wavfiles/notaccept.wav","r");
    
//    if(alarm==NULL) {
//        printf("No file");
//    }
    
    while (1) {
        if(s1 > 0.2) {
            led4 = 1;
            wait(0.5);
        } else {
            //ALARM GOES OFF
            led4 = 0;
            uLCD.cls();
            uLCD.text_width(3); //4X size text
            uLCD.text_height(3);
            uLCD.locate(0,0);
            uLCD.printf("Alerting Authorities!");
//            wait(0.2);
//            waver.play(alarm);
//            fclose(alarm);     
        }
    }
}
