#include "TEMPSensor.h"
#include "mbed.h"
// The location of the sensor on the FRDM-K64F//

AnalogIn thermometerInside(PTC10);
AnalogIn thermometerOutside1(PTB3);
AnalogIn thermometerOutside2(PTC11);
AnalogIn thermometerPanel(PTB10);

float get_outsideTemp()//function to return temperature readings from outside thermometers not in contact with the panels
{
    float readOne = thermometerOutside1.read();
    float readTwo = thermometerOutside2.read();
    float outsideTemp = ( readTwo + readOne ) / 2; //average of two outside thermometer
    return ( outsideTemp * 100 ); //conversion to celcius
}

float get_insideTemp()//function to return data from inside thermometer
{
    float insideTemp = thermometerInside.read(); // onboard in-pod thermometer
    return ( insideTemp * 100 ) ; //conversion to celcius
 }       

float get_panelTemp()//function to return data from the thermometer in contact with the solar panels
{   
    float panelTemp = thermometerPanel.read(); // on-panel thermometer
    return ( panelTemp *100 ); // conversion to celcius
}