#include "SDFileSystem.h"
#include "mbed.h"
extern Serial pc;
FILE *fp;
SDFileSystem fs(PTE3,PTE1,PTE2,PTE4,"fs");//SDFileSystem object

void createDataFile() {
    fp = fopen("/fs/dataLog.txt", "a");// open file and prepare to write
    if (fp == NULL) {
        pc.printf("Failed to open the file.\n\r");
    }
        fprintf(fp, "Time (s)\t temperature (c)\t UV (mW/cm2)\t red (mW/cm2)\t green (mW/cm2)\t blue (mW/cm2)\n\r");
}

void createDataFile_testTEMP() {
    fp = fopen("/fs/dataLog.txt", "a");// open file and prepare to write
    if (fp == NULL) {
        pc.printf("Failed to open the file.\n\r");
    }
    fprintf(fp, "Time (s)\t outside (C)\t inside (C)\t On Panel (C)\n\r");
}

void writeData(uint16_t time, float temp, float uv, uint16_t red, uint16_t green, uint16_t blue)
{
    fprintf(fp, "%.2f \t %.2f \t %.2f \t %d \t %d \t %d\n\r", time, temp, uv, red, green, blue);
}

void writeData_testTEMP(uint16_t time, float outside, float inside, float panel) {
    //output values for each
    fprintf(fp, "%.2f \t %d \t %d \t %d\n\r", time, outside, inside, panel);
}

void closeDataFile() {
    fclose(fp);
    fs.unmount();
}

bool mountSDCard() {
    bool mountFailure;
    mountFailure = fs.mount();
    return mountFailure;
}

