  //Authors: Tom, Nathan, Jeriah  
#include "mbed.h"
#include "TEMPSensor.h"
#include "SDFileSystem.h"
#include "SDSave.h"

Timer t;
DigitalOut ledBlue(LED_BLUE);
DigitalOut ledRed(LED_RED);
Serial pc(USBTX,USBRX);

int main() {//main function, calls other files to move temp,RGB,PV,UV all to one managable function
    float lastTime = 0;
    float interval = 0.5;
    ledRed = 0;
    ledBlue = 1;
    wait(0.5);
    t.start();
    pc.printf("The timer has started\n\r");
    if (mountSDCard()) {
        return -1; //end program with error status
    }
    pc.printf("The SD card is mounted\n\r");
    ledRed = 1;
    createDataFile_testTEMP();
    while (t.read()<60) {
        if (t.read()>(lastTime+interval))  {
          lastTime=t.read();
          pc.printf("temp ouside = %.2f \t inside = %.2f \t on panel = %.2f \n\r" ,get_outsideTemp(),get_insideTemp(),get_panelTemp());//prints titles and data of Temp readings
          writeData_testTEMP(lastTime,get_outsideTemp(),get_insideTemp(),get_panelTemp());//send data to writeData in SDsave.cpp
          //we will get all rgb readings through an array, with the corresponding integers going in order red, green, blue
        }
    }
    closeDataFile();
    ledBlue = 0;
    while (true) {};
} 
      