  //Authors: Tom, Nathan, Jeriah  
#include "mbed.h"
#include "TEMPSensor.h"
#include "SDFileSystem.h"
#include "SDSave.h"
#include "SolarPanel.h"
#include "UVSensor.h"
#include "RGBSensor.h"

Timer t;
DigitalOut ledBlue(LED_BLUE);
DigitalOut ledRed(LED_RED);
Serial pc(USBTX,USBRX);

int main() {//main function, calls other files to move temp,RGB,PV,UV all to one managable function
    float lastTime = 0;
    float interval = 0.5;
    int halfHour = 0;
    ledRed = 0;
    ledBlue = 1;
    wait(0.5);
    t.start();
    pc.printf("The timer has started\n\r");
    if (mountSDCard()) {
        return -1; //end program with error status
    }
    pc.printf("The SD card is mounted\n\r");
    
    uint16_t rgb[3];
    ledRed = 1;
    createDataFile();
    while (halfHour < 7) {
        if (t.read() >= 1800){
            t.start();
            halfHour++;
            }
        float totalTime = halfHour * 30 * 60 + t.read();
        if (totalTime>(lastTime+interval))  {
          lastTime=totalTime;
          get_rgb(rgb);
          pc.printf("temp ouside = %.2f (c)   inside = %.2f (c)   solar volage = %.4f (V)   UV light =%.4f   RGB Values: red = %d   green = %d   blue = %d\r\n" ,get_outsideTemp(),get_insideTemp(),get_solar(),(get_UV()),rgb[0],rgb[1],rgb[2]);//prints titles and data of Temp readings
          writeData(lastTime,get_outsideTemp(),get_insideTemp(),get_solar(),get_UV(),rgb[0],rgb[1],rgb[2]);//send data to writeData in SDsave.cpp
          
        }
    }
    closeDataFile();
    ledBlue = 1;
    while (true) {};
} 
      