// T. Bronez. rev. 2016-01-23
// Based on https://developer.mbed.org/users/loopsva/code/WDT4088/
// Put into Singleton design pattern for easy use throughout a program

#include "mbed.h"
#include "Watchdog.h"

// Global static point to singleton instance
Watchdog* Watchdog::_pInstance = NULL;

bool Watchdog::isWatchdogReset() {
    return ((LPC_WDT->MOD >> 2) & 1);
}

Watchdog::Watchdog() {
}

Watchdog* Watchdog::getInstance() {
    if(!_pInstance) { _pInstance = new Watchdog(); }
    return _pInstance;
}

void Watchdog::enable(int WDTseconds) {
    if(WDTseconds < 1) WDTseconds = 1;      //minimum watchdog time is 1 sec
    if(WDTseconds > 134) WDTseconds = 134;  //maximum watchdog time is 134 sec
    LPC_WDT->TC = 125000 * WDTseconds;      //125000 * 8uS = 1.0 second tics
    LPC_WDT->MOD = 0x3;                     //enable and restart watchdog
    Watchdog::feed();
}

void Watchdog::feed() {
    LPC_WDT->FEED = 0xaa;                   //put sequence into FEED register
    LPC_WDT->FEED = 0x55;
}
