#include "mbed.h"
#include "Camera_LS_Y201.h"
#include "Servo.h"
#include "EthernetNetIf.h"
#include "HttpServer.h"

Servo servo1(p21);
Servo servo2(p22);
DigitalOut myled(LED1);
DigitalOut myled4(LED4);
Camera_LS_Y201 cam1(p13, p14);
Serial device(p28, p27);  // tx, rx
LocalFileSystem local("local");               // Create the local filesystem under the name "local"
LocalFileSystem fs("webfs");

EthernetNetIf eth;  
HttpServer svr;

FILE *fp = NULL;
int datcnt = 0;
float ServoVal1[5] = {0,.25,.5,.75,1};
//float ServoVal2[5] = {0,.25,.5,.75,1};
float ServoVal2[5] = {1,.9,.5,.1,0};

/**
 * Callback function for readJpegFileContent.
 *
 * @param buf A pointer to a buffer.
 * @param siz A size of the buffer.
 */
void callback_func(int done, int total, uint8_t *buf, size_t siz) {
    fwrite(buf, siz, 1, fp);

    static int n = 0;
    int tmp = done * 100 / total;
    if (n != tmp) {
        n = tmp;
        // You can print the progress to LCD here.
    }
}

int capture(int n) {
    /*
     * Take a picture.(L)
     */
    if (cam1.takePicture() != 0) {
        return -1;
    }
   // lcd.locate(0, 1);
    device.printf("Captured.\r\n");
    
    char fname[64];
    
    /*
     * Open file.
     * Read the content.
     */
    snprintf(fname, sizeof(fname) - 1, "/local/IMG_%04d.jpg", n);
    fp = fopen(fname, "wb");
    if (fp == NULL) {
        return -2;
    }
    //lcd.locate(0, 0);
    device.printf("Capture: %04d\r\n", n);
    datcnt = 0;
    if (cam1.readJpegFileContent(callback_func) != 0) {
        fclose(fp);
        return -3;
    }
    fclose(fp);

    /*
     * Stop taking pictures.
     */
    cam1.stopTakingPictures();

    return 0;
}


int main() {
    device.baud(115200);
    device.printf("***********************************\r\n");
    device.printf("**** ServoCamera mbed Project  ****\r\n");
    device.printf("**** NXP mbed Design Challenge ****\r\n");
    device.printf("***********************************\r\n");
    wait(.25);

    if (cam1.reset() == 0) {
        device.printf("Camera Reset OK.\r\n ");
    }
    wait(.5);

    //device.printf("setImageSize=%d\n", cam1.setImageSize(LS_Y201::ImageSize640x480));
    //wait(1);
    device.printf("******************************\r\n");    
/*    device.printf("** MOVE SERVO               **\r\n");    
    for(float p=0; p<1.0; p += 0.01) {
        servo2 = p;
        servo1 = p;
        wait(0.15);
    }
*/
    servo2 = 0.5;
    servo1 = 0.5;
    device.printf("** SERVOs CENTERED!           **\r\n");   
    device.printf("******************************\r\n");
     wait(2);
     int cnt = 0;
     int col = 0;
     int row = 0;
     servo2 = 0.5;
     servo1 = 0.3;
     wait(1);
     for (int j = 0; j < 3; j++) {
         col = j;
         servo1 = (ServoVal1[col+1]-0.15);  // Move servo to new position
         for (int i = 0; i < 3; i++) {      
            row = i;
            servo2 = ServoVal2[row+1];      // Move servo to new position
            wait(1);
            myled4 = 0;                     // turns LED ON
            int r = capture(cnt);           // capture image
            if (r == 0) {
               device.printf("[%04d]:OK.\r\n", cnt);
            } else {
                device.printf("[%04d]:NG. (code=%d)\r\n", cnt, r);
            }
            cnt++;
            myled4 = 1;                     // turns LED OFF
          }     
    }
     servo2 = 0.5;
     servo1 = 0.3;
     //
 Base::add_rpc_class<DigitalOut>();

  device.printf("\r\nSetting up Ethernet...\r\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
   device.printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  device.printf("\r\nSetup OK\r\n");
  
  svr.addHandler<SimpleHandler>("/hello");
  svr.addHandler<RpcHandler>("/rpc");
  svr.addHandler<FSHandler>(""); //Default handler
  //Example : Access to mbed.htm : http://a.b.c.d/webfs/mbed.htm
  
  svr.bind(80);
  
  device.printf("\r\nListening @port 80...\r\n");     
     
    //
    while (1) {
        Net::poll();
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
     }
   
}
