#include "MicroBit.h"                                                                       //dem libraries tho.... don't forget 'em! (MCU specific)
#include "PCA9955A.h"

//Allows each led driver port to be triggered on/off over serial - simply send the relevant Hex character using Putty or similar: 
//(0,1,2,3,4,5,6) = segments for character 1, 
//(7,8,9,A,B,C,D) = segments for character 2, 
//(E,F) = decimal points

PCA9955A    led_cntlr(I2C_SDA0, I2C_SCL0 , 0x3f<<1);                                        //SDA, SCL, Slave_address(option)
MicroBitSerial pc(USBTX, USBRX);

void lightIt(int, int);                                                                     //function to turn on specific LEDs
void cutItA ();                                                                             //function to turn off left hand LEDs
void cutItB ();                                                                             //function to turn off right hand LEDs
void cutItC ();                                                                             //function to turn off decimal point LEDs
int state[16];

int main()
{                                                                                           //Set the operate enable pin low (it's inverted)
    led_cntlr.current( ALLPORTS, 1 );                                                       //Set all outputs to max current


    while(1){
        if (pc.readable()){                                                                 //If there's serial data available
            char sc = pc.getc();                                                            //Read it
            int s = (int)sc;
            if (s > 96)
                s = s - 87;
            else if (s > 47)
                s = s - 48;
            if (s < 16){
                state[s] = !state[s];
                int onoff = state[s];
                lightIt(s,onoff);
            }
            else if (s == 33){
                cutItA();
                cutItB();
                cutItC();
                for(int i = 0; i < 16; i++)
                    state[i] = 0;
            }
            pc.printf("%d",s);
        }
    }
}

void lightIt (int led, int o){
    led_cntlr.pwm(led,o);
}

void cutItA () {                                                                            //When called display reset LEDs on left hand side
    for ( int i = 0; i < 7; i++ ){
        led_cntlr.pwm(i,0);
    }
}

void cutItB () {                                                                            //When called display reset LEDs on right hand side
    for ( int i = 7; i < 14; i++ ){
        led_cntlr.pwm(i,0);
    }
}

void cutItC () {                                                                            //When called display reset LEDs on right hand side
    for ( int i = 14; i < 16; i++ ){
        led_cntlr.pwm(i,0);
    }
}