///////////////////////////////////////////////////////////////////////////////
// Signal Capture Library
// Author: Chris Taylor (taylorza)
#ifndef __DIGITALPINCAPTURE_H__
#define __DIGITALPINCAPTURE_H__

/** Captures the digital wave form of a pin into a timing buffer. */
class DigitalPinCapture
{
    public:
        /** Create an instance of DigitalPinCapture connected to the specified pin 
         * @note The DigitalPinCapture class polls the state of the pin and therefore might be less accurate than
         * using InterruptPinCapture. However, it has the advantage that it does not require an interrupt capable pin.
        */
        DigitalPinCapture(PinName pin, PinMode mode);
        
        /** Maximum time to wait for waveform data to arrive or completely fill the timing buffer. 
         * @param us Timeout specified in microseconds
         */
        void setReadTimeout(uint32_t us);
        
        /** Waits for the pin to transition to the trigger state and proceeds to capture the
         * pins transition timing into the timing buffer.
         * @param triggerState State that the pin must transistion to before the readings are captured
         * @param pReadings Pointer to the timing buffer that will contain the readings in microseconds
         * @param count The maximum number of readings that can be held in the buffer
         * @returns The number of timings captured in the buffer.
         */      
        int read(bool triggerState, uint32_t *pReadings, int count);
        
        /** Immediately start capturing the pin transition timing into the timing buffer.
         * @param pInitialState Pointer to a bool that will have the initial state of the pin at the time the capture started.
         * @param pReadings Pointer to the timing buffer that will contain the readings in microseconds
         * @param count The maximum number of readings that can be held in the buffer
         * @returns The number of timings captured in the buffer.
         */      
        int read(bool *pInitialState, uint32_t *pReadings, int count);
        
    private:
        int readInternal(bool *pPinState, uint32_t *pReadings, int count, bool waitForTrigger);
        
    private:        
        DigitalIn _signalPin;            
        uint32_t _readTimeout;        
};
#endif //__DIGITALPINCAPTURE_H__
