#include "mbed.h"
#include "common.h"
#include "LCD_ST7735.h"
#include "Color565.h"
#include "Raycaster.h"

static const uint8_t g_map[] = 
{
    2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
    1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,4,
    1,0,1,1,1,1,0,1,1,0,1,1,1,1,0,4,
    1,0,1,0,0,0,0,1,1,0,0,0,0,1,0,4,
    1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,
    1,1,3,4,3,3,3,0,0,2,2,2,2,2,2,4,
    1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,
    1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,4,
    1,1,1,1,0,0,1,0,0,1,0,0,3,3,3,4,
    3,0,0,0,0,0,1,0,0,1,0,0,0,0,0,4,
    3,0,0,1,1,1,0,0,0,0,1,1,1,0,0,4,
    3,0,0,1,0,0,0,0,0,0,0,0,1,0,0,4,
    3,0,0,1,0,0,2,4,4,2,0,0,1,0,0,4,
    3,0,0,1,0,0,0,0,0,0,0,0,1,0,0,4, 
    3,0,0,0,0,1,0,0,0,0,1,0,0,0,0,4,
    3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,
};

static const uint16_t g_palette[] =
{
    Color565::Black,
    Color565::Red,
    Color565::Green,
    Color565::Blue,
    Color565::Yellow
};
    
AnalogIn stickX(P0_11);
AnalogIn stickY(P0_13);

main()
{
    Raycaster rayCaster(0, 10, 160, 108, 
                        96, CELL_SIZE / 2, 
                        g_map, 16, 16, 
                        g_palette);
    
    rayCaster.setCellPosition(8, 8);
    while (true) 
    {
        rayCaster.renderFrame();
        
        if (stickX < 0.3) rayCaster.rotate(-0.1);
        else if (stickX > 0.7) rayCaster.rotate(0.1);;
        
        if (stickY < 0.3) rayCaster.move(4);
        else if (stickY > 0.7) rayCaster.move(-4);
    }    
}



