#ifndef __RATYCASTER_H__
#define __RATYCASTER_H__
class Raycaster
{
    public:
        Raycaster(int left, int top, int width, int height, 
                  int viewerDistance, int viewerHeight, 
                  const uint8_t *pMap, int mapWidth, int mapHeight,
                  const uint16_t *pPalette);
            
        void renderFrame();
        
        void setCellPosition(int x, int y);
        void rotate(float radians);
        void move(int distance);

        ~Raycaster();
    private:
        struct Sliver
        {
            uint8_t top;
            uint8_t bottom;
            uint16_t color;            
        };                
    private:
        LCD_ST7735 _display;
        
        const uint8_t *_pMap;
        int _mapWidth;
        int _mapHeight;
        const uint16_t *_pPalette;
        int _viewDistanceTimesHeight;        
        Sliver *_pSlivers;
        
        int _left;
        int _right;
        int _width;
        int _halfWidth;
        int _horizCenter;
        
        int _top;
        int _bottom;
        int _height;
        int _halfHeight;
        int _vertCenter;
        
        int _viewerDistance;
        int _viewerHeight;
        float _viewerDistanceHeightRatio;
        float _viewVolume;
        float _halfViewVolume;
                
        float _ainc;
        int _heightRatio;
        
        float _playerX;
        float _playerY;
        float _playerViewAngle;
};
#endif //__RATYCASTER_H__