#include "mbed.h"
#include "Bitmap1bpp.h"

Bitmap1bpp::Bitmap1bpp(uint16_t width, uint16_t height):
    _width(width), 
    _height(height),
    _stride((width >> 3) + ((width & 0x07) ? 1 : 0)),
    _pBitmapData(new uint8_t[_stride * height])
{
    
}

Bitmap1bpp::~Bitmap1bpp()
{
    if (_pBitmapData != NULL)
    {
        delete []_pBitmapData;
        _pBitmapData = NULL;
    }
}

void Bitmap1bpp::clear()
{
    memset(_pBitmapData, 0, _stride * _height);
}

void Bitmap1bpp::setPixel(int16_t x, int16_t y, uint16_t color)
{
    if (x < 0 || x >= _width || y < 0 || y >= _height) return;
    
    uint8_t mask = 1 << (7 - (x % 8));
    uint8_t *p = _pBitmapData + ((y * _stride) + (x / 8));
    
    if (color) *p |= mask; else *p &= ~mask;
}
