#include "mbed.h"
#include "Fix16.h"
#include "SoundBlock.h"
#include "SoundChannel.h"
#include "OneBitSound.h"

OneBitSound::OneBitSound(PinName pin) :
    _soundPin(pin)
{
    _lastPinState = _soundPin;
    _totalElapsed = 0;
    
    _ticker.attach_us(this, &OneBitSound::update, 32);
}

void OneBitSound::play(uint8_t channel, const SoundBlock soundBlocks[], int count)
{    
    _channels[channel].play(soundBlocks, count);
    
    bool nextState;
    bool updated = false;
    uint32_t bit = _soundPin;
    if (_channels[channel].update(nextState)) { bit = (updated ? bit ^ nextState : nextState); updated = true; }    
    if (updated) _soundPin = bit;
}

void OneBitSound::update()
{    
    uint32_t bit = 0;
    bool nextState = false;        
    bool updated = false;
    
    if (_channels[0].update(nextState)) { bit = (updated ? bit ^ nextState : nextState); updated = true; }
    if (_channels[1].update(nextState)) { bit = (updated ? bit ^ nextState : nextState); updated = true; }
    if (_channels[2].update(nextState)) { bit = (updated ? bit ^ nextState : nextState); updated = true; }
    if (_channels[3].update(nextState)) { bit = (updated ? bit ^ nextState : nextState); updated = true; }
    
    if (updated) _soundPin = bit;
}


