#include "mbed.h"
#include "Bitmap4bpp.h"

Bitmap4bpp::Bitmap4bpp(uint16_t width, uint16_t height) :
    _width(width), 
    _height(height),
    _stride((width >> 1) + (width & 0x01)),
    _pBitmapData(new uint8_t[_stride * height])    
{
    
}

Bitmap4bpp::~Bitmap4bpp()
{
    if (_pBitmapData != NULL)
    {
        delete []_pBitmapData;
        _pBitmapData = NULL;
    }
}

void Bitmap4bpp::clear()
{
    memset(_pBitmapData, 0, _stride * _height);
}

