#ifndef __SOUNDCHANNEL_H__
#define __SOUNDCHANNEL_H__
class SoundChannel
{   
public: 
    SoundChannel();
    
    protected:
        void play(const SoundBlock soundBlocks[], int count);
        bool update(bool &pinState);            
    
    private:
        void updateTone();
        void updateNoise();
        
        void startSoundBlock();
        bool updateCounters();
        void updateAudioCounters();
        
        static uint16_t lfsr_rand();
        
    private:
        int         _state;
        uint16_t    _stepCounter;
        uint16_t    _stepDurationCounter;
        fix16_t     _basePitchHighCount;
        fix16_t     _basePitchLowCount;
        fix16_t     _pitchHighCounter;
        fix16_t     _pitchLowCounter;
        fix16_t     _pitchOffset;
        fix16_t     _dutyOffset;
        
        const SoundBlock *_soundBlocks;        
        int         _count;
        int         _index;  
        bool        _pinState;
        
        SoundBlock  _currentSoundBlock;
        
    friend class OneBitSound;           
};
#endif //__SOUNDCHANNEL_H__