///////////////////////////////////////////////////////////////////////////////
// LCD_ST7735 - Driver for ST7735 LCD display controller
// Author: Chris Taylor (taylorza)

#ifndef __FONT_IBM_H__
#define __FONT_IBM_H__

const uint8_t font_ibm[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // Char 000 (.)
    0x7E, 0x81, 0xA5, 0x81, 0xBD, 0x99, 0x81, 0x7E, // Char 001 (.)
    0x7E, 0xFF, 0xDB, 0xFF, 0xC3, 0xE7, 0xFF, 0x7E, // Char 002 (.)
    0x6C, 0xFE, 0xFE, 0xFE, 0x7C, 0x38, 0x10, 0x00, // Char 003 (.)
    0x10, 0x38, 0x7C, 0xFE, 0x7C, 0x38, 0x10, 0x00, // Char 004 (.)
    0x38, 0x7C, 0x38, 0xFE, 0xFE, 0xD6, 0x10, 0x38, // Char 005 (.)
    0x10, 0x38, 0x7C, 0xFE, 0xFE, 0x7C, 0x10, 0x38, // Char 006 (.)
    0x00, 0x00, 0x18, 0x3C, 0x3C, 0x18, 0x00, 0x00, // Char 007 (.)
    0xFF, 0xFF, 0xE7, 0xC3, 0xC3, 0xE7, 0xFF, 0xFF, // Char 008 (.)
    0x00, 0x3C, 0x66, 0x42, 0x42, 0x66, 0x3C, 0x00, // Char 009 (.)
    0xFF, 0xC3, 0x99, 0xBD, 0xBD, 0x99, 0xC3, 0xFF, // Char 010 (.)
    0x0F, 0x07, 0x0F, 0x7D, 0xCC, 0xCC, 0xCC, 0x78, // Char 011 (.)
    0x3C, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x7E, 0x18, // Char 012 (.)
    0x3F, 0x33, 0x3F, 0x30, 0x30, 0x70, 0xF0, 0xE0, // Char 013 (.)
    0x7F, 0x63, 0x7F, 0x63, 0x63, 0x67, 0xE6, 0xC0, // Char 014 (.)
    0x18, 0xDB, 0x3C, 0xE7, 0xE7, 0x3C, 0xDB, 0x18, // Char 015 (.)
    0x80, 0xE0, 0xF8, 0xFE, 0xF8, 0xE0, 0x80, 0x00, // Char 016 (.)
    0x02, 0x0E, 0x3E, 0xFE, 0x3E, 0x0E, 0x02, 0x00, // Char 017 (.)
    0x18, 0x3C, 0x7E, 0x18, 0x18, 0x7E, 0x3C, 0x18, // Char 018 (.)
    0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x00, // Char 019 (.)
    0x7F, 0xDB, 0xDB, 0x7B, 0x1B, 0x1B, 0x1B, 0x00, // Char 020 (.)
    0x3E, 0x61, 0x3C, 0x66, 0x66, 0x3C, 0x86, 0x7C, // Char 021 (.)
    0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E, 0x7E, 0x00, // Char 022 (.)
    0x18, 0x3C, 0x7E, 0x18, 0x7E, 0x3C, 0x18, 0xFF, // Char 023 (.)
    0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x00, // Char 024 (.)
    0x18, 0x18, 0x18, 0x18, 0x7E, 0x3C, 0x18, 0x00, // Char 025 (.)
    0x00, 0x18, 0x0C, 0xFE, 0x0C, 0x18, 0x00, 0x00, // Char 026 (.)
    0x00, 0x30, 0x60, 0xFE, 0x60, 0x30, 0x00, 0x00, // Char 027 (.)
    0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xFE, 0x00, 0x00, // Char 028 (.)
    0x00, 0x24, 0x66, 0xFF, 0x66, 0x24, 0x00, 0x00, // Char 029 (.)
    0x00, 0x18, 0x3C, 0x7E, 0xFF, 0xFF, 0x00, 0x00, // Char 030 (.)
    0x00, 0xFF, 0xFF, 0x7E, 0x3C, 0x18, 0x00, 0x00, // Char 031 (.)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // Char 032 ( )
    0x18, 0x3C, 0x3C, 0x18, 0x18, 0x00, 0x18, 0x00, // Char 033 (!)
    0x66, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, // Char 034 (")
    0x6C, 0x6C, 0xFE, 0x6C, 0xFE, 0x6C, 0x6C, 0x00, // Char 035 (#)
    0x18, 0x3E, 0x60, 0x3C, 0x06, 0x7C, 0x18, 0x00, // Char 036 ($)
    0x00, 0xC6, 0xCC, 0x18, 0x30, 0x66, 0xC6, 0x00, // Char 037 (%)
    0x38, 0x6C, 0x38, 0x76, 0xDC, 0xCC, 0x76, 0x00, // Char 038 (&)
    0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, // Char 039 (')
    0x0C, 0x18, 0x30, 0x30, 0x30, 0x18, 0x0C, 0x00, // Char 040 (()
    0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x18, 0x30, 0x00, // Char 041 ())
    0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00, // Char 042 (*)
    0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00, // Char 043 (+)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, // Char 044 (,)
    0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, // Char 045 (-)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, // Char 046 (.)
    0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x80, 0x00, // Char 047 (/)
    0x38, 0x6C, 0xC6, 0xD6, 0xC6, 0x6C, 0x38, 0x00, // Char 048 (0)
    0x18, 0x38, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, // Char 049 (1)
    0x7C, 0xC6, 0x06, 0x1C, 0x30, 0x66, 0xFE, 0x00, // Char 050 (2)
    0x7C, 0xC6, 0x06, 0x3C, 0x06, 0xC6, 0x7C, 0x00, // Char 051 (3)
    0x1C, 0x3C, 0x6C, 0xCC, 0xFE, 0x0C, 0x1E, 0x00, // Char 052 (4)
    0xFE, 0xC0, 0xC0, 0xFC, 0x06, 0xC6, 0x7C, 0x00, // Char 053 (5)
    0x38, 0x60, 0xC0, 0xFC, 0xC6, 0xC6, 0x7C, 0x00, // Char 054 (6)
    0xFE, 0xC6, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x00, // Char 055 (7)
    0x7C, 0xC6, 0xC6, 0x7C, 0xC6, 0xC6, 0x7C, 0x00, // Char 056 (8)
    0x7C, 0xC6, 0xC6, 0x7E, 0x06, 0x0C, 0x78, 0x00, // Char 057 (9)
    0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, // Char 058 (:)
    0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x30, // Char 059 (;)
    0x06, 0x0C, 0x18, 0x30, 0x18, 0x0C, 0x06, 0x00, // Char 060 (<)
    0x00, 0x00, 0x7E, 0x00, 0x00, 0x7E, 0x00, 0x00, // Char 061 (=)
    0x60, 0x30, 0x18, 0x0C, 0x18, 0x30, 0x60, 0x00, // Char 062 (>)
    0x7C, 0xC6, 0x0C, 0x18, 0x18, 0x00, 0x18, 0x00, // Char 063 (?)
    0x7C, 0xC6, 0xDE, 0xDE, 0xDE, 0xC0, 0x78, 0x00, // Char 064 (@)
    0x38, 0x6C, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0x00, // Char 065 (A)
    0xFC, 0x66, 0x66, 0x7C, 0x66, 0x66, 0xFC, 0x00, // Char 066 (B)
    0x3C, 0x66, 0xC0, 0xC0, 0xC0, 0x66, 0x3C, 0x00, // Char 067 (C)
    0xF8, 0x6C, 0x66, 0x66, 0x66, 0x6C, 0xF8, 0x00, // Char 068 (D)
    0xFE, 0x62, 0x68, 0x78, 0x68, 0x62, 0xFE, 0x00, // Char 069 (E)
    0xFE, 0x62, 0x68, 0x78, 0x68, 0x60, 0xF0, 0x00, // Char 070 (F)
    0x3C, 0x66, 0xC0, 0xC0, 0xCE, 0x66, 0x3A, 0x00, // Char 071 (G)
    0xC6, 0xC6, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0x00, // Char 072 (H)
    0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, // Char 073 (I)
    0x1E, 0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78, 0x00, // Char 074 (J)
    0xE6, 0x66, 0x6C, 0x78, 0x6C, 0x66, 0xE6, 0x00, // Char 075 (K)
    0xF0, 0x60, 0x60, 0x60, 0x62, 0x66, 0xFE, 0x00, // Char 076 (L)
    0xC6, 0xEE, 0xFE, 0xFE, 0xD6, 0xC6, 0xC6, 0x00, // Char 077 (M)
    0xC6, 0xE6, 0xF6, 0xDE, 0xCE, 0xC6, 0xC6, 0x00, // Char 078 (N)
    0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, // Char 079 (O)
    0xFC, 0x66, 0x66, 0x7C, 0x60, 0x60, 0xF0, 0x00, // Char 080 (P)
    0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xCE, 0x7C, 0x0E, // Char 081 (Q)
    0xFC, 0x66, 0x66, 0x7C, 0x6C, 0x66, 0xE6, 0x00, // Char 082 (R)
    0x3C, 0x66, 0x30, 0x18, 0x0C, 0x66, 0x3C, 0x00, // Char 083 (S)
    0x7E, 0x7E, 0x5A, 0x18, 0x18, 0x18, 0x3C, 0x00, // Char 084 (T)
    0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, // Char 085 (U)
    0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x00, // Char 086 (V)
    0xC6, 0xC6, 0xC6, 0xD6, 0xD6, 0xFE, 0x6C, 0x00, // Char 087 (W)
    0xC6, 0xC6, 0x6C, 0x38, 0x6C, 0xC6, 0xC6, 0x00, // Char 088 (X)
    0x66, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x3C, 0x00, // Char 089 (Y)
    0xFE, 0xC6, 0x8C, 0x18, 0x32, 0x66, 0xFE, 0x00, // Char 090 (Z)
    0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00, // Char 091 ([)
    0xC0, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x02, 0x00, // Char 092 (\)
    0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x00, // Char 093 (])
    0x10, 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00, 0x00, // Char 094 (^)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, // Char 095 (_)
    0x30, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, // Char 096 (`)
    0x00, 0x00, 0x78, 0x0C, 0x7C, 0xCC, 0x76, 0x00, // Char 097 (a)
    0xE0, 0x60, 0x7C, 0x66, 0x66, 0x66, 0xDC, 0x00, // Char 098 (b)
    0x00, 0x00, 0x7C, 0xC6, 0xC0, 0xC6, 0x7C, 0x00, // Char 099 (c)
    0x1C, 0x0C, 0x7C, 0xCC, 0xCC, 0xCC, 0x76, 0x00, // Char 100 (d)
    0x00, 0x00, 0x7C, 0xC6, 0xFE, 0xC0, 0x7C, 0x00, // Char 101 (e)
    0x3C, 0x66, 0x60, 0xF8, 0x60, 0x60, 0xF0, 0x00, // Char 102 (f)
    0x00, 0x00, 0x76, 0xCC, 0xCC, 0x7C, 0x0C, 0xF8, // Char 103 (g)
    0xE0, 0x60, 0x6C, 0x76, 0x66, 0x66, 0xE6, 0x00, // Char 104 (h)
    0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3C, 0x00, // Char 105 (i)
    0x06, 0x00, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3C, // Char 106 (j)
    0xE0, 0x60, 0x66, 0x6C, 0x78, 0x6C, 0xE6, 0x00, // Char 107 (k)
    0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, // Char 108 (l)
    0x00, 0x00, 0xEC, 0xFE, 0xD6, 0xD6, 0xD6, 0x00, // Char 109 (m)
    0x00, 0x00, 0xDC, 0x66, 0x66, 0x66, 0x66, 0x00, // Char 110 (n)
    0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, // Char 111 (o)
    0x00, 0x00, 0xDC, 0x66, 0x66, 0x7C, 0x60, 0xF0, // Char 112 (p)
    0x00, 0x00, 0x76, 0xCC, 0xCC, 0x7C, 0x0C, 0x1E, // Char 113 (q)
    0x00, 0x00, 0xDC, 0x76, 0x60, 0x60, 0xF0, 0x00, // Char 114 (r)
    0x00, 0x00, 0x7E, 0xC0, 0x7C, 0x06, 0xFC, 0x00, // Char 115 (s)
    0x30, 0x30, 0xFC, 0x30, 0x30, 0x36, 0x1C, 0x00, // Char 116 (t)
    0x00, 0x00, 0xCC, 0xCC, 0xCC, 0xCC, 0x76, 0x00, // Char 117 (u)
    0x00, 0x00, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x00, // Char 118 (v)
    0x00, 0x00, 0xC6, 0xD6, 0xD6, 0xFE, 0x6C, 0x00, // Char 119 (w)
    0x00, 0x00, 0xC6, 0x6C, 0x38, 0x6C, 0xC6, 0x00, // Char 120 (x)
    0x00, 0x00, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0xFC, // Char 121 (y)
    0x00, 0x00, 0x7E, 0x4C, 0x18, 0x32, 0x7E, 0x00, // Char 122 (z)
    0x0E, 0x18, 0x18, 0x70, 0x18, 0x18, 0x0E, 0x00, // Char 123 ({)
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, // Char 124 (|)
    0x70, 0x18, 0x18, 0x0E, 0x18, 0x18, 0x70, 0x00, // Char 125 (})
    0x76, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // Char 126 (~)
    0x00, 0x10, 0x38, 0x6C, 0xC6, 0xC6, 0xFE, 0x00, // Char 127 (.)
    0x7C, 0xC6, 0xC0, 0xC0, 0xC6, 0x7C, 0x0C, 0x78, // Char 128 (.)
    0xCC, 0x00, 0xCC, 0xCC, 0xCC, 0xCC, 0x76, 0x00, // Char 129 (.)
    0x0C, 0x18, 0x7C, 0xC6, 0xFE, 0xC0, 0x7C, 0x00, // Char 130 (.)
    0x7C, 0x82, 0x78, 0x0C, 0x7C, 0xCC, 0x76, 0x00, // Char 131 (.)
    0xC6, 0x00, 0x78, 0x0C, 0x7C, 0xCC, 0x76, 0x00, // Char 132 (.)
    0x30, 0x18, 0x78, 0x0C, 0x7C, 0xCC, 0x76, 0x00, // Char 133 (.)
    0x30, 0x30, 0x78, 0x0C, 0x7C, 0xCC, 0x76, 0x00, // Char 134 (.)
    0x00, 0x00, 0x7E, 0xC0, 0xC0, 0x7E, 0x0C, 0x38, // Char 135 (.)
    0x7C, 0x82, 0x7C, 0xC6, 0xFE, 0xC0, 0x7C, 0x00, // Char 136 (.)
    0xC6, 0x00, 0x7C, 0xC6, 0xFE, 0xC0, 0x7C, 0x00, // Char 137 (.)
    0x30, 0x18, 0x7C, 0xC6, 0xFE, 0xC0, 0x7C, 0x00, // Char 138 (.)
    0x66, 0x00, 0x38, 0x18, 0x18, 0x18, 0x3C, 0x00, // Char 139 (.)
    0x7C, 0x82, 0x38, 0x18, 0x18, 0x18, 0x3C, 0x00, // Char 140 (.)
    0x30, 0x18, 0x00, 0x38, 0x18, 0x18, 0x3C, 0x00, // Char 141 (.)
    0xC6, 0x38, 0x6C, 0xC6, 0xFE, 0xC6, 0xC6, 0x00, // Char 142 (.)
    0x38, 0x6C, 0x7C, 0xC6, 0xFE, 0xC6, 0xC6, 0x00, // Char 143 (.)
    0x18, 0x30, 0xFE, 0xC0, 0xF8, 0xC0, 0xFE, 0x00, // Char 144 (.)
    0x00, 0x00, 0x7E, 0x18, 0x7E, 0xD8, 0x7E, 0x00, // Char 145 (.)
    0x3E, 0x6C, 0xCC, 0xFE, 0xCC, 0xCC, 0xCE, 0x00, // Char 146 (.)
    0x7C, 0x82, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, // Char 147 (.)
    0xC6, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, // Char 148 (.)
    0x30, 0x18, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, // Char 149 (.)
    0x78, 0x84, 0x00, 0xCC, 0xCC, 0xCC, 0x76, 0x00, // Char 150 (.)
    0x60, 0x30, 0xCC, 0xCC, 0xCC, 0xCC, 0x76, 0x00, // Char 151 (.)
    0xC6, 0x00, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0xFC, // Char 152 (.)
    0xC6, 0x38, 0x6C, 0xC6, 0xC6, 0x6C, 0x38, 0x00, // Char 153 (.)
    0xC6, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, // Char 154 (.)
    0x18, 0x18, 0x7E, 0xC0, 0xC0, 0x7E, 0x18, 0x18, // Char 155 (.)
    0x38, 0x6C, 0x64, 0xF0, 0x60, 0x66, 0xFC, 0x00, // Char 156 (.)
    0x66, 0x66, 0x3C, 0x7E, 0x18, 0x7E, 0x18, 0x18, // Char 157 (.)
    0xF8, 0xCC, 0xCC, 0xFA, 0xC6, 0xCF, 0xC6, 0xC7, // Char 158 (.)
    0x0E, 0x1B, 0x18, 0x3C, 0x18, 0xD8, 0x70, 0x00, // Char 159 (.)
    0x18, 0x30, 0x78, 0x0C, 0x7C, 0xCC, 0x76, 0x00, // Char 160 (.)
    0x0C, 0x18, 0x00, 0x38, 0x18, 0x18, 0x3C, 0x00, // Char 161 (.)
    0x0C, 0x18, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, // Char 162 (.)
    0x18, 0x30, 0xCC, 0xCC, 0xCC, 0xCC, 0x76, 0x00, // Char 163 (.)
    0x76, 0xDC, 0x00, 0xDC, 0x66, 0x66, 0x66, 0x00, // Char 164 (.)
    0x76, 0xDC, 0x00, 0xE6, 0xF6, 0xDE, 0xCE, 0x00, // Char 165 (.)
    0x3C, 0x6C, 0x6C, 0x3E, 0x00, 0x7E, 0x00, 0x00, // Char 166 (.)
    0x38, 0x6C, 0x6C, 0x38, 0x00, 0x7C, 0x00, 0x00, // Char 167 (.)
    0x18, 0x00, 0x18, 0x18, 0x30, 0x63, 0x3E, 0x00, // Char 168 (.)
    0x00, 0x00, 0x00, 0xFE, 0xC0, 0xC0, 0x00, 0x00, // Char 169 (.)
    0x00, 0x00, 0x00, 0xFE, 0x06, 0x06, 0x00, 0x00, // Char 170 (.)
    0x63, 0xE6, 0x6C, 0x7E, 0x33, 0x66, 0xCC, 0x0F, // Char 171 (.)
    0x63, 0xE6, 0x6C, 0x7A, 0x36, 0x6A, 0xDF, 0x06, // Char 172 (.)
    0x18, 0x00, 0x18, 0x18, 0x3C, 0x3C, 0x18, 0x00, // Char 173 (.)
    0x00, 0x33, 0x66, 0xCC, 0x66, 0x33, 0x00, 0x00, // Char 174 (.)
    0x00, 0xCC, 0x66, 0x33, 0x66, 0xCC, 0x00, 0x00, // Char 175 (.)
    0x22, 0x88, 0x22, 0x88, 0x22, 0x88, 0x22, 0x88, // Char 176 (.)
    0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, // Char 177 (.)
    0x77, 0xDD, 0x77, 0xDD, 0x77, 0xDD, 0x77, 0xDD, // Char 178 (.)
    0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, // Char 179 (.)
    0x18, 0x18, 0x18, 0x18, 0xF8, 0x18, 0x18, 0x18, // Char 180 (.)
    0x18, 0x18, 0xF8, 0x18, 0xF8, 0x18, 0x18, 0x18, // Char 181 (.)
    0x36, 0x36, 0x36, 0x36, 0xF6, 0x36, 0x36, 0x36, // Char 182 (.)
    0x00, 0x00, 0x00, 0x00, 0xFE, 0x36, 0x36, 0x36, // Char 183 (.)
    0x00, 0x00, 0xF8, 0x18, 0xF8, 0x18, 0x18, 0x18, // Char 184 (.)
    0x36, 0x36, 0xF6, 0x06, 0xF6, 0x36, 0x36, 0x36, // Char 185 (.)
    0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, // Char 186 (.)
    0x00, 0x00, 0xFE, 0x06, 0xF6, 0x36, 0x36, 0x36, // Char 187 (.)
    0x36, 0x36, 0xF6, 0x06, 0xFE, 0x00, 0x00, 0x00, // Char 188 (.)
    0x36, 0x36, 0x36, 0x36, 0xFE, 0x00, 0x00, 0x00, // Char 189 (.)
    0x18, 0x18, 0xF8, 0x18, 0xF8, 0x00, 0x00, 0x00, // Char 190 (.)
    0x00, 0x00, 0x00, 0x00, 0xF8, 0x18, 0x18, 0x18, // Char 191 (.)
    0x18, 0x18, 0x18, 0x18, 0x1F, 0x00, 0x00, 0x00, // Char 192 (.)
    0x18, 0x18, 0x18, 0x18, 0xFF, 0x00, 0x00, 0x00, // Char 193 (.)
    0x00, 0x00, 0x00, 0x00, 0xFF, 0x18, 0x18, 0x18, // Char 194 (.)
    0x18, 0x18, 0x18, 0x18, 0x1F, 0x18, 0x18, 0x18, // Char 195 (.)
    0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, // Char 196 (.)
    0x18, 0x18, 0x18, 0x18, 0xFF, 0x18, 0x18, 0x18, // Char 197 (.)
    0x18, 0x18, 0x1F, 0x18, 0x1F, 0x18, 0x18, 0x18, // Char 198 (.)
    0x36, 0x36, 0x36, 0x36, 0x37, 0x36, 0x36, 0x36, // Char 199 (.)
    0x36, 0x36, 0x37, 0x30, 0x3F, 0x00, 0x00, 0x00, // Char 200 (.)
    0x00, 0x00, 0x3F, 0x30, 0x37, 0x36, 0x36, 0x36, // Char 201 (.)
    0x36, 0x36, 0xF7, 0x00, 0xFF, 0x00, 0x00, 0x00, // Char 202 (.)
    0x00, 0x00, 0xFF, 0x00, 0xF7, 0x36, 0x36, 0x36, // Char 203 (.)
    0x36, 0x36, 0x37, 0x30, 0x37, 0x36, 0x36, 0x36, // Char 204 (.)
    0x00, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, // Char 205 (.)
    0x36, 0x36, 0xF7, 0x00, 0xF7, 0x36, 0x36, 0x36, // Char 206 (.)
    0x18, 0x18, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, // Char 207 (.)
    0x36, 0x36, 0x36, 0x36, 0xFF, 0x00, 0x00, 0x00, // Char 208 (.)
    0x00, 0x00, 0xFF, 0x00, 0xFF, 0x18, 0x18, 0x18, // Char 209 (.)
    0x00, 0x00, 0x00, 0x00, 0xFF, 0x36, 0x36, 0x36, // Char 210 (.)
    0x36, 0x36, 0x36, 0x36, 0x3F, 0x00, 0x00, 0x00, // Char 211 (.)
    0x18, 0x18, 0x1F, 0x18, 0x1F, 0x00, 0x00, 0x00, // Char 212 (.)
    0x00, 0x00, 0x1F, 0x18, 0x1F, 0x18, 0x18, 0x18, // Char 213 (.)
    0x00, 0x00, 0x00, 0x00, 0x3F, 0x36, 0x36, 0x36, // Char 214 (.)
    0x36, 0x36, 0x36, 0x36, 0xFF, 0x36, 0x36, 0x36, // Char 215 (.)
    0x18, 0x18, 0xFF, 0x18, 0xFF, 0x18, 0x18, 0x18, // Char 216 (.)
    0x18, 0x18, 0x18, 0x18, 0xF8, 0x00, 0x00, 0x00, // Char 217 (.)
    0x00, 0x00, 0x00, 0x00, 0x1F, 0x18, 0x18, 0x18, // Char 218 (.)
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Char 219 (.)
    0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, // Char 220 (.)
    0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, // Char 221 (.)
    0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, // Char 222 (.)
    0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, // Char 223 (.)
    0x00, 0x00, 0x76, 0xDC, 0xC8, 0xDC, 0x76, 0x00, // Char 224 (.)
    0x78, 0xCC, 0xCC, 0xD8, 0xCC, 0xC6, 0xCC, 0x00, // Char 225 (.)
    0xFE, 0xC6, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x00, // Char 226 (.)
    0x00, 0x00, 0xFE, 0x6C, 0x6C, 0x6C, 0x6C, 0x00, // Char 227 (.)
    0xFE, 0xC6, 0x60, 0x30, 0x60, 0xC6, 0xFE, 0x00, // Char 228 (.)
    0x00, 0x00, 0x7E, 0xD8, 0xD8, 0xD8, 0x70, 0x00, // Char 229 (.)
    0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x7C, 0xC0, // Char 230 (.)
    0x00, 0x76, 0xDC, 0x18, 0x18, 0x18, 0x18, 0x00, // Char 231 (.)
    0x7E, 0x18, 0x3C, 0x66, 0x66, 0x3C, 0x18, 0x7E, // Char 232 (.)
    0x38, 0x6C, 0xC6, 0xFE, 0xC6, 0x6C, 0x38, 0x00, // Char 233 (.)
    0x38, 0x6C, 0xC6, 0xC6, 0x6C, 0x6C, 0xEE, 0x00, // Char 234 (.)
    0x0E, 0x18, 0x0C, 0x3E, 0x66, 0x66, 0x3C, 0x00, // Char 235 (.)
    0x00, 0x00, 0x7E, 0xDB, 0xDB, 0x7E, 0x00, 0x00, // Char 236 (.)
    0x06, 0x0C, 0x7E, 0xDB, 0xDB, 0x7E, 0x60, 0xC0, // Char 237 (.)
    0x1E, 0x30, 0x60, 0x7E, 0x60, 0x30, 0x1E, 0x00, // Char 238 (.)
    0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, // Char 239 (.)
    0x00, 0xFE, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0x00, // Char 240 (.)
    0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x7E, 0x00, // Char 241 (.)
    0x30, 0x18, 0x0C, 0x18, 0x30, 0x00, 0x7E, 0x00, // Char 242 (.)
    0x0C, 0x18, 0x30, 0x18, 0x0C, 0x00, 0x7E, 0x00, // Char 243 (.)
    0x0E, 0x1B, 0x1B, 0x18, 0x18, 0x18, 0x18, 0x18, // Char 244 (.)
    0x18, 0x18, 0x18, 0x18, 0x18, 0xD8, 0xD8, 0x70, // Char 245 (.)
    0x00, 0x18, 0x00, 0x7E, 0x00, 0x18, 0x00, 0x00, // Char 246 (.)
    0x00, 0x76, 0xDC, 0x00, 0x76, 0xDC, 0x00, 0x00, // Char 247 (.)
    0x38, 0x6C, 0x6C, 0x38, 0x00, 0x00, 0x00, 0x00, // Char 248 (.)
    0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, // Char 249 (.)
    0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, // Char 250 (.)
    0x0F, 0x0C, 0x0C, 0x0C, 0xEC, 0x6C, 0x3C, 0x1C, // Char 251 (.)
    0x6C, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, // Char 252 (.)
    0x78, 0x0C, 0x18, 0x30, 0x7C, 0x00, 0x00, 0x00, // Char 253 (.)
    0x00, 0x00, 0x3C, 0x3C, 0x3C, 0x3C, 0x00, 0x00, // Char 254 (.)
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  // Char 255 (.)
};

#endif // __FONT_IBM_H__