#include "mbed.h"
#include "Constants.h"
#include "Canvas.h"
#include "GameEngine.h"
#include "Assets.h"
#include "GameScreen.h"
#include "Beeper.h"

static const uint16_t palette[] = 
{
    Color565::Black,
    Color565::Blue,
    Color565::Red,
    0xfe20
};

void showIntro();

GameScreen gameScreen;

//char buffer[10];
//Timer timer;

main()
{    
    Game::Surface.setPalette((uint16_t*)palette);
    Game::Surface.clearScreen(0);    
    Game::Surface.setOrientation(LCD_ST7735::Rotate270, false);
    
    showIntro();
    
    Game::Surface.clearScreen(HUD_BACKGROUND);
    
  //  timer.start();
//    int lastTime = timer.read_us();
    
//    int updateCounter = 0;    
    while(true)
    {   
        gameScreen.update();        
        gameScreen.draw();
/*
        int time = timer.read_us();
        int elapsedTime = time - lastTime;
        lastTime = time;
        
        sprintf(buffer, "%d", elapsedTime);
        Game::Surface.drawString(font_ibm, 104, 120, buffer);
        
        ++updateCounter;
*/        
    }     
}

void showIntro()
{
    // Title
    Game::Surface.drawBitmap(22, 0, titleGraphics, 0, 0, 115, 22, Color565::Aqua, Color565::Black);
    
    // Image
    Game::Surface.drawBitmap(51, 50, titleGraphics, 0, 24, 57, 29, Color565::Blue, Color565::Black);
    
    // Press [] to start
    Game::Surface.drawBitmap(43, 102, titleGraphics, 60, 24, 73, 8, Color565::White, Color565::Black);
    
    // (c)2015
    Game::Surface.drawBitmap(44, 120, titleGraphics, 60, 34, 71, 8, Color565::White, Color565::Black);
    
    while (!GameInput::isSquarePressed());
}
