#include "GameObject.h"

#ifndef __RALLYCAR_H__
#define __RALLYCAR_H__
class RallyCar : public GameObject
{
public:
    RallyCar() :
        _direction(Up),
        _desiredDirection(Up),
        _state(Idle)
    {
        setCollisionRect(4, 4, 8, 8);
    }
    
    enum Direction { Up, Left, Down, Right, None };
    enum State  { Idle, Driving, StartSpinning, Spinning, StartCrash, Crashed };
    
    virtual void reset(){};
    
    inline Direction getDirection() { return _direction; }
    inline void setDirection(Direction direction) { if (_direction != None) _direction = direction; }
    
    inline Direction getDesiredDirection() { return _desiredDirection; }
    inline void setDesiredDirection(Direction direction) { if (_desiredDirection != None) _desiredDirection = direction; }
    
    inline void setState(State state) { _state = state; }
    inline State getState() { return _state; }
private:
    Direction _direction;
    Direction _desiredDirection;
    State     _state;    
};
#endif //__RALLYCAR_H__