#ifndef __SPRITE_H__
#define __SPRITE_H__

class Sprite
{
    public:
        Sprite(const ImageFrame *frames[]) :
            _frames(frames),
            _frameCount(0),
            _frameIndex(0)
        {            
            for(;; _frameCount++)
            {
                if (frames[_frameCount] == NULL) break;
            }
            
        }
        
        void animate()
        {
            _frameIndex = (_frameIndex + 1) % _frameCount;  
        }
        
        inline const ImageFrame& getFrame() const
        {
            return *_frames[_frameIndex];
        }
        
    private:
        const ImageFrame **_frames;
        uint8_t     _frameCount;
        uint8_t     _frameIndex;                                                
};

#endif //__SPRITE_H__

