#ifndef __POINT_H__
#define __POINT_H__
struct Point
{
    int16_t X;
    int16_t Y;
    
    Point() :
        X(0),
        Y(0)
    {
    }
    
    Point(int16_t x, int16_t y) :
        X(x),
        Y(y)
    {        
    }
    
    inline bool operator==(const Point &rhs)
    {
        return X == rhs.X && Y == rhs.Y;
    }
    
    inline bool operator!=(const Point &rhs)
    {
        return !(*this == rhs);
    }
};
#endif //__POINT_H__