#include "Point.h"
#include "Rect.h"

#ifndef __GAMEOBJECT_H__
#define __GAMEOBJECT_H__

class TileViewer;

class GameObject
{
public:
    GameObject();

public: 
    void setPosition(const Point &position);
    void setSpriteId(uint8_t spriteId);
    void setSpeed(uint8_t speed);
    void setCollisionRect(uint8_t x, uint8_t y, uint8_t w, uint8_t h);
    void animate();
    virtual void update();
    virtual void draw();
    
//protected: 
public:
    bool moveLeft();
    bool moveRight();
    bool moveUp();
    bool moveDown();
    
    inline bool canGoLeft() { return canGoLeft(_position.X, _position.Y); }
    inline bool canGoRight(){ return canGoRight(_position.X, _position.Y); };
    inline bool canGoUp()   { return canGoUp(_position.X, _position.Y); };
    inline bool canGoDown() { return canGoDown(_position.X, _position.Y); };
    
    const GameObject* detectCollision();
    bool detectCollision(GameObject* other);
    const Block* detectBlock();
    Rect getCollisionRect();
    
    bool pickupObject();        
    
    inline Point& getPosition() {return _position;}    
    
    void setParent(TileViewer *pParent) { _pParent = pParent; }
    TileViewer* getParent() { return _pParent; }
    
private:
    bool canGoLeft(uint16_t x, uint16_t y);
    bool canGoRight(uint16_t x, uint16_t y);
    bool canGoUp(uint16_t x, uint16_t y);
    bool canGoDown(uint16_t x, uint16_t y);
    
private:  
    uint8_t     _spriteId;
    Point       _position;
    uint8_t    _speed;
    uint8_t    _animationCounter;
    Rect       _collisionRect;
    
    TileViewer   *_pParent;
    
    friend class TileViewer;
};

#endif //__GAMEOBJECT_H__
