#include "ImageFrame.h"

#ifndef __BLOCK_H__
#define __BLOCK_H__

class Block
{
public:
    enum Type { Background, Foreground, Solid, Deadly, Pickup }; 
    
public:
    Block(const ImageFrame *frame, Type type) :
        _frame(frame),
        _type(type),
        _data(0)
    {
    }
    
    Block(const ImageFrame *frame, Type type, uint8_t data) :
        _frame(frame),
        _type(type),
        _data(data)
    {
    }
    
    inline const ImageFrame& getFrame() const { return *_frame; }        
    inline uint8_t getData() const { return _data; }
    inline Type getType() const { return (Type)_type; }
    
private:
    const ImageFrame    *_frame;
    uint8_t             _type;
    uint8_t             _data;  
};

#endif //__BLOCK_H__


