#include "SpriteSheet.h"

#ifndef __ASSETS_H__
#define __ASSETS_H__

static Bitmap2bpp spriteSheet(bmp);

static const ImageFrame emptyBlock(spriteSheet, 0, 0, 8, 8);
static const ImageFrame wallBlock(spriteSheet, 48, 32, 8, 8);
static const ImageFrame flagBlock(spriteSheet, 48, 40, 8, 8);

static const ImageFrame playerUp(spriteSheet, 0, 0, 16, 16);
static const ImageFrame playerRight(spriteSheet, 16, 0, 16, 16);
static const ImageFrame playerDown(spriteSheet, 32, 0, 16, 16);
static const ImageFrame playerLeft(spriteSheet, 48, 0, 16, 16);

static const ImageFrame enemyUp(spriteSheet, 0, 16, 16, 16);
static const ImageFrame enemyRight(spriteSheet, 16, 16, 16, 16);
static const ImageFrame enemyDown(spriteSheet, 32, 16, 16, 16);
static const ImageFrame enemyLeft(spriteSheet, 48, 16, 16, 16);

static const ImageFrame flag(spriteSheet, 48, 40, 8, 8);

static const ImageFrame smoke(spriteSheet, 0, 48, 16, 16);

static const ImageFrame crash1(spriteSheet, 0, 32, 16, 16);
static const ImageFrame crash2(spriteSheet, 16, 32, 16, 16);
static const ImageFrame crash3(spriteSheet, 32, 32, 16, 16);

static const ImageFrame *playerUpAnimation[] = {&playerUp, NULL};
static const ImageFrame *playerLeftAnimation[] = {&playerLeft, NULL};
static const ImageFrame *playerDownAnimation[] = {&playerDown, NULL};
static const ImageFrame *playerRightAnimation[] = {&playerRight, NULL};

static const ImageFrame *enemyUpAnimation[] = {&enemyUp, NULL};
static const ImageFrame *enemyLeftAnimation[] = {&enemyLeft, NULL};
static const ImageFrame *enemyDownAnimation[] = {&enemyDown, NULL};
static const ImageFrame *enemyRightAnimation[] = {&enemyRight, NULL};

static const ImageFrame *flagAnimation[] = {&flag, NULL};
static const ImageFrame *smokeAnimation[] = {&smoke, NULL};
static const ImageFrame *crashAnimation[] = {&crash1, &crash2, &crash3, NULL};

// Blocks
static const Block blocks[] =
{
    Block(&emptyBlock, Block::Background),      // 0 - Empty block
    Block(&wallBlock, Block::Solid),            // 1 - Wall block    
}; 

// Sprites
static Sprite sprites[] =
{
    Sprite(playerUpAnimation),      // 0
    Sprite(playerRightAnimation),   // 1
    Sprite(playerDownAnimation),    // 2
    Sprite(playerLeftAnimation),    // 3
    
    Sprite(enemyUpAnimation),       // 4
    Sprite(enemyRightAnimation),    // 5
    Sprite(enemyDownAnimation),     // 6
    Sprite(enemyLeftAnimation),     // 7    
    
    Sprite(flagAnimation),          // 8    
    Sprite(smokeAnimation),         // 9
    Sprite(crashAnimation),         // 10
};
#endif //__ASSETS_H__