#include "Constants.h"
#include "GameObject.h"
#include "RallyCar.h"

#ifndef __SMOKE_H__
#define __SMOKE_H__

class Smoke : public GameObject
{
public:
    Smoke() :
        _active(false)
    {
        setSpriteId(9);  
        setCollisionRect(4, 4, 8, 8);
    }
    
    void setCars(RallyCar **cars) { _cars = cars; }
    
    virtual void update()
    {
        GameObject::update();
        
        if (_active)
        {
            // Exclude first car, the player car
            for (int i = 1; i < MAX_CARS; ++i)
            {       
                if (_cars[i]->getState() != RallyCar::StartSpinning && 
                    _cars[i]->getState() != RallyCar::Spinning)
                {
                    if (detectCollision((GameObject*)_cars[i]))
                    {       
                        _cars[i]->setPosition(getPosition());                             
                        _cars[i]->setState(RallyCar::StartSpinning);
                    }            
                }
            }
            
            if (_liveCounter-- == 0)
            {                
                for (int i = 0; i < MAX_CARS; ++i)
                {       
                    if (_cars[i]->getState() == RallyCar::StartSpinning || 
                        _cars[i]->getState() == RallyCar::Spinning)
                    {
                        if (detectCollision((GameObject*)_cars[i]))
                        {                               
                            _cars[i]->setState(RallyCar::Driving);
                        }            
                    }
                }
                _active = false;                
            }
        }                        
    }
    
    virtual void draw()
    {
        if (_active)
        {
            GameObject::draw();
        }
    }
    
    inline bool getActive() { return _active; }
    inline void setActive(bool active) 
    {
        if (_active != active)
        {
            _active = active;  
            _liveCounter = 90;
        }        
    }
    
private:
    bool        _active;
    RallyCar  **_cars;
    uint16_t    _liveCounter;
};
#endif //__SMOKE_H__