#include "mbed.h"
#include "Bitmap4bpp.h"

Bitmap4bpp::Bitmap4bpp(uint16_t width, uint16_t height) :
    _width(width), 
    _height(height),
    _stride((width >> 1) + (width & 0x01)),
    _pBitmapData(new uint8_t[_stride * height])    
{
    
}

Bitmap4bpp::~Bitmap4bpp()
{
    if (_pBitmapData != NULL)
    {
        delete []_pBitmapData;
        _pBitmapData = NULL;
    }
}

void Bitmap4bpp::clear()
{
    memset(_pBitmapData, 0, _stride * _height);
}

void Bitmap4bpp::setPixel(int16_t x, int16_t y, uint16_t color)
{
    if (x < 0 || x >= _width || y < 0 || y >= _height) return;
    
    int bit = (x % 2) << 2;
    uint8_t mask = (color  & 0x0f) << (4 - bit);
    uint8_t *p = _pBitmapData + ((y * _stride) + (x / 2));
    
    *p &= ~mask; 
    *p |= mask;
}

