#include "Bitmap2bpp.h"
#include "Block.h"
#include "Sprite.h"
#include "Canvas.h"
#include "GameObject.h"

#ifndef __TILEVIEWER_H__
#define __TILEVIEWER_H__

#define MAX_GAMEOBJECTS 20

class TileViewer
{
public:
    TileViewer(uint8_t viewTilesX, uint8_t viewTilesY);
    
    void update();
    void draw();
    
public:    
    void setMap(const uint8_t *map, uint8_t mapTilesX, uint8_t mapTilesY, const Block *blocks, Sprite *sprites);        
    
    void addGameObject(GameObject *gameObject);
    void removeGameObject(GameObject *gameObject);    
    void track(GameObject *pGameObject);
    
    const GameObject* detectCollision(GameObject *primary);        
    bool detectCollision(GameObject *o1, GameObject *o2);
    const Block* detectBlock(GameObject *primary);
                                
    void centerAt(int16_t x, int16_t y);
    
    bool canEnter(uint16_t x, uint16_t y);
    const Block& getBlock(uint16_t x, uint16_t y);        
    void animate(uint8_t spriteId);
    bool pickupObject(uint8_t tileX, uint8_t tileY);
    
    inline int16_t getOffsetX() { return _offsetX; }
    inline int16_t getOffsetY() { return _offsetY; }
    inline uint8_t getMapTilesX() { return _mapTilesX; }
    inline uint8_t getMapTilesY() { return _mapTilesY; }
    
    void drawSprite(uint8_t spriteId, int16_t x, int16_t y);
    
    inline Canvas<Bitmap2bpp>& getCanvas() { return _canvas; }
        
private:
    Bitmap2bpp          _bitmap;
    Canvas<Bitmap2bpp>  _canvas;
    uint8_t             _viewTilesX;
    uint8_t             _viewTilesY;
    
    const uint8_t       *_map;        
    uint8_t             _mapTilesX;
    uint8_t             _mapTilesY;
    
    int16_t             _offsetX;
    int16_t             _offsetY;
    
    const Block         *_blocks;
    Sprite              *_sprites;
    
    GameObject          *_gameObjects[MAX_GAMEOBJECTS];
    GameObject          *_pTrackedGameObject;    
        
    friend class GameObject;    
};
#endif //__TILEVIEWER_H__