#ifndef __RECT_H__
#define __RECT_H__

#include <algorithm>

struct Rect
{
    int16_t left;
    int16_t top;
    int16_t right;
    int16_t bottom;
    
    Rect() :
        left(0),
        top(0),
        right(0),
        bottom(0)
    {
    }
    
    Rect(int16_t l, int16_t t, int16_t w, int16_t h) :
        left(l),
        top(t),
        right(l + (w - 1)),        
        bottom(t + (h - 1))
    {
    }
    
    Rect Intersection(Rect &rect)
    {
        uint8_t x1 = max(left, rect.left);
        uint8_t y1 = max(top, rect.top);
        uint8_t x2 = min(right, rect.right);
        uint8_t y2 = min(bottom, rect.bottom);
        
        return Rect(x1, y1, x2, y2); 
    }
    
    inline int16_t getWidth() const { return right - left; }
    inline int16_t getHeight() const { return bottom - top; }
};

#endif //__RECT_H__