#ifndef __IMAGEFRAME_H__
#define __IMAGEFRAME_H__

class ImageFrame
{
    public:
        ImageFrame(const Bitmap2bpp &bmp, uint8_t x, uint8_t y, uint8_t width, uint8_t height) :
            _bmp(bmp),
            _x(x),
            _y(y),
            _width(width),
            _height(height)            
        {            
        }
        
        inline const Bitmap2bpp& getBitmap() const { return _bmp; };
        inline uint8_t getX() const { return _x; }
        inline uint8_t getY() const { return _y; }
        inline uint8_t getWidth() const { return _width; }
        inline uint8_t getHeight() const { return _height; }
        
    private:
        const Bitmap2bpp &_bmp;
        uint8_t _x;
        uint8_t _y;
        uint8_t _width;
        uint8_t _height;
        
};

#endif //__IMAGEFRAME_H__

