#include "Beeper.h"

DigitalOut Beeper::_speaker(P0_18);

void Beeper::beep(int freq, int ms)
{
    float delay = 1.0f / (float)freq;
    float duration = (float)ms / 1000.0f;
    while (duration > 0)
    {
        _speaker = !_speaker;        
        wait(delay);
        duration -= delay;
    }
}

void Beeper::noise(int freq, int ms)
{
    float delay = 1.0f / (float)freq;
    float duration = (float)ms / 1000.0f;
    while (duration > 0)
    {
        _speaker = lfsr_rand() & 0x01;
        wait(delay);
        duration -= delay;
    }
}