#include "LCD_ST7735.h"
#include "Bitmap1bpp.h"

#ifndef __CHIP8EMULATOR_H__
#define __CHIP8EMULATOR_H__

class Chip8Emulator
{
public:
    Chip8Emulator(LCD_ST7735 &screen, const uint8_t *program, uint16_t programSize, uint8_t leftKey, uint8_t rightKey, uint8_t upKey, uint8_t downKey, uint8_t fireKey, uint8_t startKey);    
    void run();
    
private:
    uint8_t rnd();
    bool isKeyPressed(uint8_t key);
    uint8_t getKeyPressed();
    void plot(int x, int y, uint8_t pattern);
    
private:
    Bitmap1bpp          _bmp;
    LCD_ST7735          &_screen;    
    uint8_t             _delay;
    uint8_t             _sound;
    uint16_t            _pc;
    uint16_t            _sp;
    uint16_t            _i;
    uint8_t             _memory[4096];
    uint16_t            _stack[16];
    uint8_t             _registers[16];    
    
    uint8_t             _leftKey;
    uint8_t             _rightKey;
    uint8_t             _upKey;
    uint8_t             _downKey;
    uint8_t             _fireKey;
    uint8_t             _startKey;
    
private:
    static const int OFFSET_X  =   16;
    static const int OFFSET_Y  =   32;  
    
    static const uint8_t _font[];    
};

#endif //__CHIP8EMULATOR_H__