#include "Base.h"

#ifndef __CANVAS_H__
#define __CANVAS_H__

template <typename T>
class Canvas
{
    public:
        Canvas(T &surface) :
            _surface(surface)
        {
            
        }
        
        inline void clear()
        {
            _surface.clear();
        }
        
        inline void setPixel(int x, int y, uint16_t color)
        {
            _surface.setPixel(x, y, color);
        }
        
        inline uint16_t getPixel(int x, int y)
        {
            return _surface.getPixel(x, y);
        }
        
        void drawLine(int x1, int y1, int x2, int y2, uint16_t color)
        {
            int dx = abs(x2 - x1);
            int dy = abs(y2 - y1);
            
            if (dx == 0) 
            {
                if (y1 > y2) swap(y1, y2);
                _surface.fastVLine(y1, y2, x1, color);
                return;
            }
            else if(dy == 0)
            {
                if (x1 > x2) swap(x1, x2);
                _surface.fastHLine(x1, x2, y1, color);
                return;
            }
           
            int sx = (x1 < x2) ? 1 : -1;
            int sy = (y1 < y2) ? 1 : -1;
            int err = dx - dy;
            while(x1 != x2 || y1 != y2)
            {
                setPixel(x1, y1, color);
                int e2 = err << 1;
                if (e2 > -dy)
                {
                    err -= dy;
                    x1 += sx;            
                }
                if (e2 < dx)
                {
                    err += dx;
                    y1 += sy;
                }
            }
            setPixel(x2, y2, color);
        }
        
        void drawRect(int x1, int y1, int x2, int y2, uint16_t color)
        {
            if (x1 > x2) swap(x1, x2);
            if (y1 > y2) swap(y1, y2);
            
            _surface.fastHLine(x1, x2, y1, color);
            _surface.fastHLine(x1, x2, y2, color);
            
            _surface.fastVLine(y1, y2, x1, color);
            _surface.fastVLine(y1, y2, x2, color);            
        }
        
        void fillRect(int x1, int y1, int x2, int y2, uint16_t color)
        {
            if (x1 > x2) swap(x1, x2);
            if (y1 > y2) swap(y1, y2);
            
            for (int x = x1; x <= x2; ++x)
            {
                _surface.fastVLine(y1, y2, x, color);
            }
        }
        
        void drawBitmap(int x, int y, T &bmp, int srcX, int srcY, int srcWidth, int srcHeight, bool transparent)
        {
            _surface.drawBitmap(x, y, bmp, srcX, srcY, srcWidth, srcHeight, transparent);
        }
           
    private:
        T &_surface;
};

#endif // __CANVAS_H__