#ifndef __SCREEN3_H__
#define __SCREEN3_H__

class Screen3 : public Scene
{
public:
    Screen3() :
        _player(),
        _enemy1(2, PatrollingEnemy::UpDown),
        _enemy2(2, PatrollingEnemy::UpDown)              
    {
        Game::Surface.clearScreen();
                        
        addGameObject(&_enemy1);
        addGameObject(&_enemy2);                       
        addGameObject(&_player);
        
        restartScreen();
    }
    
    virtual void restartScreen()
    {
        _player.setStartPosition(136, 96);        
        _enemy1.setStartPosition(24, 16);        
        _enemy2.setStartPosition(88, 32);        
                
        setPosition(0, 8);
        setMap(Maps::Screen3, 20, 15, blocks, sprites);
        
        Scene::restartScreen();
    }
    
private:    
    Player          _player;
    PatrollingEnemy _enemy1;
    PatrollingEnemy _enemy2;                    
};

#endif //__SCREEN3_H__
