#ifndef __SCREEN2_H__
#define __SCREEN2_H__

class Screen2 : public Scene
{
public:
    Screen2() :
        _player(),
        _enemy1(4),
        _enemy2(4)              
    {
        Game::Surface.clearScreen();
        
        addGameObject(&_enemy1);
        addGameObject(&_enemy2);        
        addGameObject(&_player);
        
        restartScreen();
    }
    
    virtual void restartScreen()
    {
        _player.setStartPosition(8, 8);        
        _enemy1.setStartPosition(140, 8);        
        _enemy2.setStartPosition(90, 32);        
        
        setPosition(0, 32);
        setMap(Maps::Screen2, 20, 7, blocks, sprites);
        
        Scene::restartScreen();
    }
    
private:    
    Player        _player;
    BouncingEnemy _enemy1;
    BouncingEnemy _enemy2;            
};

#endif //__SCREEN2_H__
