#ifndef __SPRITE_H__
#define __SPRITE_H__

class Sprite
{
    public:
        Sprite(const ImageFrame *frames[], uint8_t foregroundColor) :
            _frames(frames),
            _frameCount(0),
            _frameIndex(0),            
            _foregroundColor(foregroundColor)
        {            
            for(;; _frameCount++)
            {
                if (frames[_frameCount] == NULL) break;
            }
            
        }
        
        void animate()
        {
            _frameIndex = (_frameIndex + 1) % _frameCount;  
        }
        
        uint8_t* getBits(int row) const
        {
            return _frames[_frameIndex]->getBits(row);
        }
        
        inline uint16_t getForegroundColor() const { return _foregroundColor; }
        
    private:
        const ImageFrame **_frames;
        uint8_t     _frameCount;
        uint8_t     _frameIndex;        
        uint8_t     _foregroundColor;                                
};

#endif //__SPRITE_H__

