#ifndef __SCENE_H__
#define __SCENE_H__

#define MAX_GAMEOBJECTS 3
#define MAX_PICKUPS 5

class Scene
{
    public:
        Scene();
        virtual ~Scene();
        
        inline Point getPointFromScene(Point &pt) { return Point(_x + pt.X, _y + pt.Y); }

    protected:
        virtual void restartScreen();
        virtual void update();
        virtual void draw();
        
    protected:
        void setMap(const uint8_t *map, uint8_t xCells, uint8_t yCells, const Block *blocks, Sprite *sprites);
        void addGameObject(GameObject *gameObject);
        void removeGameObject(GameObject *gameObject);
                
        const GameObject* detectCollision(GameObject *primary);        
        const Block* detectBlock(GameObject *primary);
        
        void setPosition(uint8_t x, uint8_t y);
        void drawMap();                
        
        void drawBlock(uint8_t blockId, int16_t x, int16_t y);
        void drawSprite(uint8_t spriteId, int16_t x, int16_t y, int16_t dx, int16_t dy, bool flip);
        
        inline uint8_t getMapXCells() {return _xCells;}
        inline uint8_t getMapYCells() {return _xCells;}
        
        inline uint8_t getX() {return _x;}
        inline uint8_t getY() {return _y;}
                
    protected:
        bool canEnter(uint16_t x, uint16_t y);
        bool canEnterFromTop(uint16_t x, uint16_t y);
        const Block& getBlock(uint16_t x, uint16_t y);
        
        void animate(uint8_t spriteId);
        
    private:       
        bool pickupObject(uint8_t cellX, uint8_t cellY);
        bool isHeld(uint8_t cellX, uint8_t cellY);
        void compose(const Block& block, uint8_t x, uint8_t y);
        void compose(const Sprite& sprite, uint8_t x, uint8_t y, bool flip);
        bool detectCollision(GameObject *o1, GameObject *o2);
        
    private:
        static Bitmap4bpp BitmapBuffer;
        
        GameObject      *_gameObjects[MAX_GAMEOBJECTS];
        const uint8_t   *_map; 
        uint8_t         _x;
        uint8_t         _y;  
        uint8_t         _objectsHeld;
        uint8_t         _xCells;
        uint8_t         _yCells;              
        const Block     *_blocks;
        Sprite          *_sprites;
        Point           _pickups[MAX_PICKUPS];
        
    friend class Game;
    friend class GameObject;
};
#endif //__SCENE_H__