#ifndef __POINT_H__
#define __POINT_H__
struct Point
{
    uint8_t X;
    uint8_t Y;

    Point() :
        X(0),
        Y(0)
    {
    }
    
    Point(uint8_t x, uint8_t y) :
        X(x),
        Y(y)
    {        
    }
    
    inline bool operator==(const Point &rhs)
    {
        return X == rhs.X && Y == rhs.Y;
    }
    
    inline bool operator!=(const Point &rhs)
    {
        return !(*this == rhs);
    }
};
#endif //__POINT_H__