#include "GameEngine.h"

#include "SoundBlock.h"
#include "SoundChannel.h"
#include "OneBitSound.h"

static OneBitSound g_sound(P0_18);
static Timer g_frameTimer;

LCD_ST7735 Game::Surface(
    P0_19,
    P0_20,
    P0_7,
    P0_21,
    P0_22,
    P1_15,
    P0_2,
    LCD_ST7735::RGB);
    
Game *Game::Instance = NULL;
    
void Game::playEffect(uint8_t channel, const SoundBlock *effect, uint8_t count)
{
    g_sound.play(channel, effect, count);         
}
    
Game::Game() :
    _pScene(NULL),
    _pNextScene(NULL),
    _lives(3),
    _score(0),
    _speedAdjust(0)
{
    Game::Instance = this; 
}

void Game::run()
{ 
    g_frameTimer.start();
    int timeAccumulator = 0;
    int lastFrameTime = g_frameTimer.read_us();    
    
    while(true)
    {   
        int timestamp = g_frameTimer.read_us();        
        int elapsedTime = timestamp - lastFrameTime;
        lastFrameTime = timestamp;
        
        g_sound.update(elapsedTime);
        
        timeAccumulator += elapsedTime;
        if (timeAccumulator >= (32000 - _speedAdjust))
        {
            update();
            draw();
            if (_pNextScene != NULL)
            {
                _pScene = _pNextScene;
                _pNextScene = NULL;
            }
            timeAccumulator -= (32000 - _speedAdjust);
        }
        else
        {
            wait_us(1);
        }        
    }
}

void Game::die()
{
    if (_lives > 1)
    {
        --_lives;
        if (_pScene != NULL) _pScene->restartScreen();
    }
    else
    {
        _lives = 0;         
    }
}

void Game::update()
{
    if (_pScene != NULL) _pScene->update();
}

void Game::draw()
{
    if (_pScene != NULL) _pScene->draw();    
}




