class PatrollingEnemy : public GameObject
{
    public:
        enum Direction { UpDown, LeftRight };
        
        PatrollingEnemy(uint8_t spriteId, Direction direction) :            
            _direction(direction),
            _primaryDirection(true)
        {
            setSpriteId(spriteId); 
            setSpeed(1);
        }
        
        virtual void update()
        {
            if (_primaryDirection)
            {              
                if (_direction == UpDown)
                {
                    if (!moveUp()) _primaryDirection = false;
                } 
                else if (_direction == LeftRight)
                {
                    if (!moveLeft() || isOpenBelow(-4))
                    {
                        _primaryDirection = false;
                    }
                }
            }
            else
            {
                if (_direction == UpDown)
                {
                    if (!moveDown()) _primaryDirection = true;
                } 
                else if (_direction == LeftRight)
                {
                    if (!moveRight() || isOpenBelow(17))
                    {
                        _primaryDirection = true;
                    }
                }
            }
            animate();
        }
        
    private:        
        Direction _direction;
        bool _primaryDirection;
};
