#include "mbed.h"
#include "Fix16.h"
#include "SoundBlock.h"

SoundBlock::SoundBlock(ToneType toneType, uint16_t stepCount, uint16_t stepDuration, uint16_t pitch, int16_t pitchSlide, uint8_t duty, int8_t dutySlide)    
{
    initialize(toneType, stepCount, stepDuration, pitch, pitchSlide, duty, dutySlide);
}

SoundBlock::SoundBlock(ToneType toneType, uint16_t stepCount, uint16_t stepDuration)    
{
    initialize(toneType, stepCount, stepDuration, 0, 0, 128, 0);
}

SoundBlock::SoundBlock() {}

void SoundBlock::initialize(ToneType toneType, uint16_t stepCount, uint16_t stepDuration, uint16_t pitch, int16_t pitchSlide, uint8_t duty, int8_t dutySlide)
{
    _toneType = toneType;
    
    _stepCount = stepCount;
    _stepDuration = stepDuration;
    _pitch = fix16_from(pitch);
    _pitchSlide = fix16_from(pitchSlide);
    _duty = duty;
    _dutySlide = dutySlide;
} 

