#ifndef __ASSETS_H__
#define __ASSETS_H__

// Block images
static const ImageFrame emptyBlock(bmp, 0, 0);
static const ImageFrame brickBlock(bmp, 16, 48);
static const ImageFrame meshFenceTopBlock(bmp, 24, 48);
static const ImageFrame meshFenceBlock(bmp, 32, 48);
static const ImageFrame platformBlock(bmp, 40, 48);
static const ImageFrame brickTrimBlock(bmp, 48, 48);
static const ImageFrame leftLadderBlock(bmp, 16, 56);
static const ImageFrame rightLadderBlock(bmp, 24, 56);
static const ImageFrame wallBlock(bmp, 56, 48);
static const ImageFrame spikeyPlantBlock(bmp, 32, 56);
static const ImageFrame keyBlock(bmp, 40, 56);
static const ImageFrame diamondBlock(bmp, 48, 56);
static const ImageFrame ropeBlock(bmp, 56, 56);


// Sprite images
static const ImageFrame playerWalk1(bmp, 0, 0);
static const ImageFrame playerWalk2(bmp, 16, 0);
static const ImageFrame playerWalk3(bmp, 32, 0);
static const ImageFrame playerWalk4(bmp, 48, 0);

static const ImageFrame playerClimb1(bmp, 0, 64);
static const ImageFrame playerClimb2(bmp, 16, 64);
static const ImageFrame playerClimb3(bmp, 32, 64);
static const ImageFrame playerClimb4(bmp, 48, 64);

static const ImageFrame angryBird1(bmp, 0, 16);
static const ImageFrame angryBird2(bmp, 16, 16);
static const ImageFrame angryBird3(bmp, 32, 16);
static const ImageFrame angryBird4(bmp, 48, 16);

static const ImageFrame mineCart1(bmp, 0, 32);
static const ImageFrame mineCart2(bmp, 16, 32);
static const ImageFrame mineCart3(bmp, 32, 32);
static const ImageFrame mineCart4(bmp, 48, 32);

static const ImageFrame bubble1(bmp, 0, 48);

// Blocks
const Block blocks[] =
{
    Block(&emptyBlock, Block::Background, 0, 0),        // 0 - Empty block
    Block(&brickBlock, Block::Solid, 2, 0),             // 1 - Brick - Red on black
    Block(&meshFenceTopBlock, Block::Background, 1, 0), // 2 - Mesh fence top - Blue on black
    Block(&meshFenceBlock, Block::Background, 1, 0),    // 3 - Mesh fence - Blue on black
    Block(&platformBlock, Block::Platform, 5, 0),       // 4 - Platform - Cyan on black
    Block(&brickTrimBlock, Block::Background, 2, 0),    // 5 - Brick trim - Red on black
    Block(&leftLadderBlock, Block::Ladder, 6, 0),       // 6 - Left ladder half - Yellow on black
    Block(&rightLadderBlock, Block::Ladder, 6, 0),      // 7 - Right ladder half - Yellow on black
    Block(&wallBlock, Block::Ladder, 5, 0),             // 8 - Wall - Cyan on black
    Block(&spikeyPlantBlock, Block::Deadly, 4, 0),      // 9 - Deadly spikey plant block - Green on black
    Block(&keyBlock, Block::Pickup, 3, 0, 1),           // 10 - Key block - Magenta on black, Data = 1 (Exit screen)
    Block(&diamondBlock, Block::Pickup, 6, 0),          // 11 - Diamond block - Yellow on Black
    Block(&ropeBlock, Block::Ladder, 6, 0),             // 12 - Rope - Yellow on black
}; 

// Sprite animation sequences
const ImageFrame *playerWalking[] = { &playerWalk1, &playerWalk2, &playerWalk3, &playerWalk4, NULL };
const ImageFrame *playerClimbing[] = { &playerClimb1, &playerClimb2, &playerClimb3, &playerClimb4, NULL };
const ImageFrame *angryBird[] = { &angryBird1, &angryBird2, &angryBird3, &angryBird4, NULL };
const ImageFrame *mineCart[] = { &mineCart1, &mineCart2, &mineCart3, &mineCart4, NULL };
const ImageFrame *bubble[] = { &bubble1, NULL };

// Sprites
Sprite sprites[] =
{
    Sprite(playerWalking, 7),   // 0 - Player walking
    Sprite(playerClimbing, 7),  // 1 - Player climbing
    Sprite(angryBird, 6),       // 2 - Angry bird
    Sprite(mineCart, 3),        // 3 - Mine cart
    Sprite(bubble, 1)           // 4 - Bubble
};

#endif //__ASSETS_H__